/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mxnet.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.mxnet.util.NativeLibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NativeLibraryLoader$ {
    public static final NativeLibraryLoader$ MODULE$;
    private final Logger org$apache$mxnet$util$NativeLibraryLoader$$logger;
    private final String libPathInJar;
    private final File _tempDir;

    static {
        new NativeLibraryLoader$();
    }

    public Logger org$apache$mxnet$util$NativeLibraryLoader$$logger() {
        return this.org$apache$mxnet$util$NativeLibraryLoader$$logger;
    }

    private String libPathInJar() {
        return this.libPathInJar;
    }

    private File _tempDir() {
        return this._tempDir;
    }

    public void loadLibrary(String libname) throws UnsatisfiedLinkError {
        String string;
        String mappedLibname = System.mapLibraryName(libname);
        if (mappedLibname.endsWith("dylib")) {
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().info("Replaced .dylib with .jnilib");
            string = mappedLibname.replace(".dylib", ".jnilib");
        } else {
            string = mappedLibname;
        }
        String loadLibname = string;
        this.org$apache$mxnet$util$NativeLibraryLoader$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to load ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{loadLibname})));
        String libFileInJar = new StringBuilder().append((Object)this.libPathInJar()).append((Object)loadLibname).toString();
        this.saveLibraryToTemp("libmxnet.so", "/lib/native/libmxnet.so", true);
        this.saveLibraryToTemp("libgfortran.so.3", "/lib/native/libgfortran.so.3", false);
        this.saveLibraryToTemp("libquadmath.so.0", "/lib/native/libquadmath.so.0", false);
        this.saveLibraryToTemp("libiomp5.so", "/lib/native/libiomp5.so", false);
        this.saveLibraryToTemp("libiomp5.dylib", "/lib/native/libiomp5.dylib", false);
        this.saveLibraryToTemp("libmklml_intel.so", "/lib/native/libmklml_intel.so", false);
        this.saveLibraryToTemp("libmklml.dylib", "/lib/native/libmklml.dylib", false);
        this.saveLibraryToTemp("libmkldnn.so.0", "/lib/native/libmkldnn.so.0", false);
        this.saveLibraryToTemp("libmkldnn.0.dylib", "/lib/native/libmkldnn.0.dylib", false);
        File tempfile = this.saveLibraryToTemp(libname, libFileInJar, true);
        this.loadLibraryFromFile(libname, tempfile);
    }

    private String unifyOSName(String osname) {
        String string = osname.startsWith("Windows") ? "Windows" : BoxedUnit.UNIT;
        return osname;
    }

    private String getUnifiedOSName() {
        return this.unifyOSName(System.getProperty("os.name"));
    }

    private File createTempFile(String name) throws IOException {
        return new File(this._tempDir(), name);
    }

    private void loadLibraryFromFile(String libname, File tempfile) {
        try {
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().debug("Loading library from {}", new Object[]{tempfile.getPath()});
            System.load(tempfile.getPath());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().error("Couldn't load copied link file: {}", new Object[]{unsatisfiedLinkError.toString()});
            throw unsatisfiedLinkError;
        }
    }

    private File saveLibraryToTemp(String libname, String resource, boolean required) {
        try {
            File file;
            InputStream is = this.getClass().getResourceAsStream(resource);
            if (is == null) {
                if (required) {
                    throw new UnsatisfiedLinkError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find the resource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resource})));
                }
                file = null;
            } else {
                File tempfile = new File(this._tempDir(), libname);
                FileOutputStream os = new FileOutputStream(tempfile);
                this.org$apache$mxnet$util$NativeLibraryLoader$$logger().debug("tempfile.getPath() = {}", new Object[]{tempfile.getPath()});
                long savedTime = System.currentTimeMillis();
                byte[] buf = new byte[8192];
                int len = is.read(buf);
                while (len > 0) {
                    ((OutputStream)os).write(buf, 0, len);
                    len = is.read(buf);
                }
                ((OutputStream)os).close();
                is.close();
                double seconds = (double)(System.currentTimeMillis() - savedTime) / 1000.0;
                this.org$apache$mxnet$util$NativeLibraryLoader$$logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copying ", " took ", " seconds."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{libname, BoxesRunTime.boxToDouble((double)seconds)})));
                file = tempfile;
            }
            return file;
        }
        catch (IOException iOException) {
            throw new UnsatisfiedLinkError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create temp file for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{libname})));
        }
    }

    private final File liftedTree1$1() {
        File file;
        try {
            File tempDir = File.createTempFile("mxnet", "");
            if (tempDir.delete() && tempDir.mkdir()) {
                String string = this.getUnifiedOSName();
                String string2 = "Windows";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    throw new RuntimeException("Windows not supported yet.");
                }
            } else {
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't create directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempDir.getAbsolutePath()})));
            }
            Runtime.getRuntime().addShutdownHook(new Thread(tempDir){
                private final File tempDir$1;

                public void run() {
                    Predef$.MODULE$.refArrayOps((Object[])this.tempDir$1.listFiles()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(File f) {
                            NativeLibraryLoader$.MODULE$.org$apache$mxnet$util$NativeLibraryLoader$$logger().info(new StringBuilder().append((Object)"Deleting ").append((Object)f.getAbsolutePath()).toString());
                            if (!f.delete()) {
                                NativeLibraryLoader$.MODULE$.org$apache$mxnet$util$NativeLibraryLoader$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't delete temporary file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.getAbsolutePath()})));
                            }
                        }
                    });
                    NativeLibraryLoader$.MODULE$.org$apache$mxnet$util$NativeLibraryLoader$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempDir$1.getAbsolutePath()})));
                    if (!this.tempDir$1.delete()) {
                        NativeLibraryLoader$.MODULE$.org$apache$mxnet$util$NativeLibraryLoader$$logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't delete temporary directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempDir$1.getAbsolutePath()})));
                    }
                }
                {
                    this.tempDir$1 = tempDir$1;
                }
            });
            file = tempDir;
        }
        catch (IOException iOException) {
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().error("Couldn't create temporary directory: {}", new Object[]{iOException.getMessage()});
            file = null;
        }
        return file;
    }

    private NativeLibraryLoader$() {
        MODULE$ = this;
        this.org$apache$mxnet$util$NativeLibraryLoader$$logger = LoggerFactory.getLogger(NativeLibraryLoader.class);
        this.libPathInJar = "/lib/native/";
        this._tempDir = this.liftedTree1$1();
    }
}

