/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mxnet.infer;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.mxnet.Context;
import org.apache.mxnet.Context$;
import org.apache.mxnet.NDArray;
import org.apache.mxnet.NDArray$;
import org.apache.mxnet.Shape;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;

public final class ImageClassifier$ {
    public static final ImageClassifier$ MODULE$;

    static {
        new ImageClassifier$();
    }

    public BufferedImage reshapeImage(BufferedImage img, int newWidth, int newHeight) {
        BufferedImage resizedImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(img, 0, 0, newWidth, newHeight, null);
        g.dispose();
        return resizedImage;
    }

    public NDArray bufferedImageToPixels(BufferedImage resizedImage, Shape inputImageShape) {
        int w = resizedImage.getWidth();
        int h = resizedImage.getHeight();
        int[] pixels = resizedImage.getRGB(0, 0, w, h, null, 0, w);
        float[] result = new float[3 * h * w];
        for (int row = 0; row < h; ++row) {
            for (int col = 0; col < w; ++col) {
                int rgb = pixels[row * w + col];
                result[0 * h * w + row * w + col] = rgb >> 16 & 0xFF;
                result[1 * h * w + row * w + col] = rgb >> 8 & 0xFF;
                result[2 * h * w + row * w + col] = rgb & 0xFF;
            }
        }
        resizedImage.flush();
        NDArray pixelsArray = NDArray$.MODULE$.array(result, inputImageShape, NDArray$.MODULE$.array$default$3());
        return pixelsArray;
    }

    /*
     * WARNING - void declaration
     */
    public BufferedImage loadImageFromFile(String inputImagePath) {
        void var2_2;
        BufferedImage img = ImageIO.read(new File(inputImagePath));
        return var2_2;
    }

    public Traversable<BufferedImage> loadInputBatch(List<String> inputImagePaths) {
        return (Traversable)inputImagePaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BufferedImage apply(String path) {
                return ImageIO.read(new File(path));
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public Context[] $lessinit$greater$default$3() {
        return Context$.MODULE$.ctx2Array(Context$.MODULE$.cpu(Context$.MODULE$.cpu$default$1()));
    }

    public Option<Object> $lessinit$greater$default$4() {
        return new Some((Object)BoxesRunTime.boxToInteger((int)0));
    }

    private ImageClassifier$() {
        MODULE$ = this;
    }
}

