Public Class MyTranslucencyForm
    Inherits f_in_box__lib.f_in_box__form

    Private m_nX As Integer = 0
    Private m_nY As Integer = 0

    Private m_nLeft As Integer = 0
    Private m_nTop As Integer = 0

    Public Sub New()
        MyBase.New()

        InitializeComponent()

    End Sub

    Protected Overrides Sub OnMouseDown(ByVal e As MouseEventArgs)
        m_nX = Left + e.X
        m_nY = Top + e.Y

        m_nLeft = Left
        m_nTop = Top

        Capture = True

        MyBase.OnMouseDown(e)
    End Sub

    Protected Overrides Sub OnMouseMove(ByVal e As MouseEventArgs)
        If Capture Then
            Left = m_nLeft + (Left + e.X - m_nX)
            Top = m_nTop + (Top + e.Y - m_nY)
        End If

        MyBase.OnMouseMove(e)
    End Sub

    Protected Overrides Sub OnMouseUp(ByVal e As MouseEventArgs)
        Capture = False

        MyBase.OnMouseUp(e)
    End Sub

    Private Sub MyTranslucencyForm_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Visible = True

        Text = "Sample 4 - Translucency"

        Dim Menu As New ContextMenu

        Dim MenuItemMinimize As New MenuItem
        MenuItemMinimize.Text = "Minimize"
        Menu.MenuItems.Add(MenuItemMinimize)
        AddHandler MenuItemMinimize.Click, AddressOf Me.OnMenuMinimize

        Dim MenuItemClose As New MenuItem
        MenuItemClose.Text = "Close"
        Menu.MenuItems.Add(MenuItemClose)
        AddHandler MenuItemClose.Click, AddressOf Me.OnMenuClose

        ' Add separator
        Menu.MenuItems.Add("-")

        Dim MenuItemAbout As New MenuItem
        MenuItemAbout.Text = "More about F-IN-BOX"
        Menu.MenuItems.Add(MenuItemAbout)
        AddHandler MenuItemAbout.Click, AddressOf Me.OnMenuAbout

        Dim MenuItemOrder As New MenuItem
        MenuItemOrder.Text = "Buy license"
        Menu.MenuItems.Add(MenuItemOrder)
        AddHandler MenuItemOrder.Click, AddressOf Me.OnMenuOrder

        ContextMenu = Menu
    End Sub

    Private Sub OnMenuMinimize(ByVal sender As Object, ByVal e As System.EventArgs)
        WindowState = FormWindowState.Minimized
    End Sub

    Private Sub OnMenuClose(ByVal sender As Object, ByVal e As System.EventArgs)
        Close()
    End Sub

    Private Sub OnMenuAbout(ByVal sender As Object, ByVal e As System.EventArgs)
        System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/")
    End Sub

    Private Sub OnMenuOrder(ByVal sender As Object, ByVal e As System.EventArgs)
        System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/order.html")
    End Sub

    Private Sub InitializeComponent()
        '
        'MyTranslucencyForm
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(300, 300)
        Me.Name = "MyTranslucencyForm"

    End Sub
End Class
