using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Xml;

namespace Sample08_Advanced_FLV_Player
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button ButtonOrder;
		internal System.Windows.Forms.Button ButtonAbout;
		internal System.Windows.Forms.CheckBox CheckBoxEnableSounds;
		private System.Windows.Forms.TrackBar trackBarSoundVolume;
		private System.Windows.Forms.Label labelSoundVolume;
		internal System.Windows.Forms.OpenFileDialog openFileDialogFlashFile;
		private f_in_box__lib.f_in_box__control f_in_box__control1;
		internal System.Windows.Forms.Button ButtonPlayFLV;
		internal System.Windows.Forms.Button buttonPlay;
		internal System.Windows.Forms.Button buttonPause;
        private System.Windows.Forms.CheckBox checkBoxShowControls;
		private System.Windows.Forms.Label LabelInfo;
        private System.Timers.Timer timer1;
        private ContextMenuStrip contextMenuFLV;
        private ToolStripMenuItem playFLVFromFileToolStripMenuItem;
        private ToolStripMenuItem playFLVFromURLToolStripMenuItem;
        private ToolStripMenuItem playFLVFromRTMPSourceToolStripMenuItem;
        private ToolStripMenuItem playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem;
        private CheckBox checkBoxPlayAutomatically;
        private TrackBar trackBarVideoPosition;
        internal Button buttonBack;
        internal Button buttonForward;
        private IContainer components;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            this.ButtonOrder = new System.Windows.Forms.Button();
            this.ButtonAbout = new System.Windows.Forms.Button();
            this.ButtonPlayFLV = new System.Windows.Forms.Button();
            this.CheckBoxEnableSounds = new System.Windows.Forms.CheckBox();
            this.trackBarSoundVolume = new System.Windows.Forms.TrackBar();
            this.labelSoundVolume = new System.Windows.Forms.Label();
            this.openFileDialogFlashFile = new System.Windows.Forms.OpenFileDialog();
            this.buttonPlay = new System.Windows.Forms.Button();
            this.buttonPause = new System.Windows.Forms.Button();
            this.checkBoxShowControls = new System.Windows.Forms.CheckBox();
            this.LabelInfo = new System.Windows.Forms.Label();
            this.timer1 = new System.Timers.Timer();
            this.contextMenuFLV = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.playFLVFromFileToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.playFLVFromURLToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.playFLVFromRTMPSourceToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.f_in_box__control1 = new f_in_box__lib.f_in_box__control();
            this.checkBoxPlayAutomatically = new System.Windows.Forms.CheckBox();
            this.trackBarVideoPosition = new System.Windows.Forms.TrackBar();
            this.buttonBack = new System.Windows.Forms.Button();
            this.buttonForward = new System.Windows.Forms.Button();
            ((System.ComponentModel.ISupportInitialize)(this.trackBarSoundVolume)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.timer1)).BeginInit();
            this.contextMenuFLV.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.trackBarVideoPosition)).BeginInit();
            this.SuspendLayout();
            // 
            // ButtonOrder
            // 
            this.ButtonOrder.Location = new System.Drawing.Point(488, 476);
            this.ButtonOrder.Name = "ButtonOrder";
            this.ButtonOrder.Size = new System.Drawing.Size(136, 23);
            this.ButtonOrder.TabIndex = 13;
            this.ButtonOrder.Text = "Buy license";
            this.ButtonOrder.Click += new System.EventHandler(this.ButtonOrder_Click);
            // 
            // ButtonAbout
            // 
            this.ButtonAbout.Location = new System.Drawing.Point(488, 444);
            this.ButtonAbout.Name = "ButtonAbout";
            this.ButtonAbout.Size = new System.Drawing.Size(136, 23);
            this.ButtonAbout.TabIndex = 12;
            this.ButtonAbout.Text = "More about F-IN-BOX";
            this.ButtonAbout.Click += new System.EventHandler(this.ButtonAbout_Click);
            // 
            // ButtonPlayFLV
            // 
            this.ButtonPlayFLV.Location = new System.Drawing.Point(8, 404);
            this.ButtonPlayFLV.Name = "ButtonPlayFLV";
            this.ButtonPlayFLV.Size = new System.Drawing.Size(152, 23);
            this.ButtonPlayFLV.TabIndex = 10;
            this.ButtonPlayFLV.Text = "Play FLV...";
            this.ButtonPlayFLV.Click += new System.EventHandler(this.ButtonPlayFLV_Click);
            // 
            // CheckBoxEnableSounds
            // 
            this.CheckBoxEnableSounds.Checked = true;
            this.CheckBoxEnableSounds.CheckState = System.Windows.Forms.CheckState.Checked;
            this.CheckBoxEnableSounds.Location = new System.Drawing.Point(8, 468);
            this.CheckBoxEnableSounds.Name = "CheckBoxEnableSounds";
            this.CheckBoxEnableSounds.Size = new System.Drawing.Size(104, 24);
            this.CheckBoxEnableSounds.TabIndex = 9;
            this.CheckBoxEnableSounds.Text = "Enable sounds";
            this.CheckBoxEnableSounds.CheckedChanged += new System.EventHandler(this.CheckBoxEnableSounds_CheckedChanged);
            // 
            // trackBarSoundVolume
            // 
            this.trackBarSoundVolume.Location = new System.Drawing.Point(112, 468);
            this.trackBarSoundVolume.Maximum = 100;
            this.trackBarSoundVolume.Name = "trackBarSoundVolume";
            this.trackBarSoundVolume.Size = new System.Drawing.Size(280, 45);
            this.trackBarSoundVolume.TabIndex = 15;
            this.trackBarSoundVolume.TickFrequency = 10;
            this.trackBarSoundVolume.Value = 100;
            this.trackBarSoundVolume.Scroll += new System.EventHandler(this.trackBarSoundVolume_Scroll);
            // 
            // labelSoundVolume
            // 
            this.labelSoundVolume.Location = new System.Drawing.Point(400, 476);
            this.labelSoundVolume.Name = "labelSoundVolume";
            this.labelSoundVolume.Size = new System.Drawing.Size(48, 23);
            this.labelSoundVolume.TabIndex = 16;
            this.labelSoundVolume.Text = "label1";
            // 
            // openFileDialogFlashFile
            // 
            this.openFileDialogFlashFile.Filter = "Flash files (*.swf;*.flv)|*.swf;*.flv|Flash movies (*.swf)|*.swf|Flash video file" +
                "s (*.flv)|*.flv|All files (*.*)|*.*||";
            this.openFileDialogFlashFile.RestoreDirectory = true;
            this.openFileDialogFlashFile.ShowReadOnly = true;
            // 
            // buttonPlay
            // 
            this.buttonPlay.Location = new System.Drawing.Point(176, 404);
            this.buttonPlay.Name = "buttonPlay";
            this.buttonPlay.Size = new System.Drawing.Size(64, 23);
            this.buttonPlay.TabIndex = 10;
            this.buttonPlay.Text = "Play";
            this.buttonPlay.Click += new System.EventHandler(this.buttonPlay_Click);
            // 
            // buttonPause
            // 
            this.buttonPause.Location = new System.Drawing.Point(248, 404);
            this.buttonPause.Name = "buttonPause";
            this.buttonPause.Size = new System.Drawing.Size(64, 23);
            this.buttonPause.TabIndex = 10;
            this.buttonPause.Text = "Pause";
            this.buttonPause.Click += new System.EventHandler(this.buttonPause_Click);
            // 
            // checkBoxShowControls
            // 
            this.checkBoxShowControls.Checked = true;
            this.checkBoxShowControls.CheckState = System.Windows.Forms.CheckState.Checked;
            this.checkBoxShowControls.Location = new System.Drawing.Point(495, 383);
            this.checkBoxShowControls.Name = "checkBoxShowControls";
            this.checkBoxShowControls.Size = new System.Drawing.Size(104, 24);
            this.checkBoxShowControls.TabIndex = 19;
            this.checkBoxShowControls.Text = "Show controls";
            this.checkBoxShowControls.CheckedChanged += new System.EventHandler(this.checkBoxShowControls_CheckedChanged);
            // 
            // LabelInfo
            // 
            this.LabelInfo.Location = new System.Drawing.Point(12, 430);
            this.LabelInfo.Name = "LabelInfo";
            this.LabelInfo.Size = new System.Drawing.Size(272, 23);
            this.LabelInfo.TabIndex = 20;
            // 
            // timer1
            // 
            this.timer1.Enabled = true;
            this.timer1.Interval = 200;
            this.timer1.SynchronizingObject = this;
            this.timer1.Elapsed += new System.Timers.ElapsedEventHandler(this.timer1_Elapsed);
            // 
            // contextMenuFLV
            // 
            this.contextMenuFLV.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.playFLVFromFileToolStripMenuItem,
            this.playFLVFromURLToolStripMenuItem,
            this.playFLVFromRTMPSourceToolStripMenuItem,
            this.playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem});
            this.contextMenuFLV.Name = "contextMenuFLV";
            this.contextMenuFLV.Size = new System.Drawing.Size(453, 92);
            // 
            // playFLVFromFileToolStripMenuItem
            // 
            this.playFLVFromFileToolStripMenuItem.Name = "playFLVFromFileToolStripMenuItem";
            this.playFLVFromFileToolStripMenuItem.Size = new System.Drawing.Size(452, 22);
            this.playFLVFromFileToolStripMenuItem.Text = "Play FLV from file...";
            this.playFLVFromFileToolStripMenuItem.Click += new System.EventHandler(this.playFLVFromFileToolStripMenuItem_Click);
            // 
            // playFLVFromURLToolStripMenuItem
            // 
            this.playFLVFromURLToolStripMenuItem.Name = "playFLVFromURLToolStripMenuItem";
            this.playFLVFromURLToolStripMenuItem.Size = new System.Drawing.Size(452, 22);
            this.playFLVFromURLToolStripMenuItem.Text = "Play FLV from URL...";
            this.playFLVFromURLToolStripMenuItem.Click += new System.EventHandler(this.playFLVFromURLToolStripMenuItem_Click);
            // 
            // playFLVFromRTMPSourceToolStripMenuItem
            // 
            this.playFLVFromRTMPSourceToolStripMenuItem.Name = "playFLVFromRTMPSourceToolStripMenuItem";
            this.playFLVFromRTMPSourceToolStripMenuItem.Size = new System.Drawing.Size(452, 22);
            this.playFLVFromRTMPSourceToolStripMenuItem.Text = "Play FLV from RTMP source...";
            this.playFLVFromRTMPSourceToolStripMenuItem.Click += new System.EventHandler(this.playFLVFromRTMPSourceToolStripMenuItem_Click);
            // 
            // playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem
            // 
            this.playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem.Name = "playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem" +
                "";
            this.playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem.Size = new System.Drawing.Size(452, 22);
            this.playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem.Text = "Play FLV embedded in the application -- play directly without temporary files!";
            this.playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem.Click += new System.EventHandler(this.playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem_Click);
            // 
            // f_in_box__control1
            // 
            this.f_in_box__control1.Context = null;
            this.f_in_box__control1.FlashProperty_AlignMode = 0;
            this.f_in_box__control1.FlashProperty_AllowFullscreen = false;
            this.f_in_box__control1.FlashProperty_AllowScriptAccess = "";
            this.f_in_box__control1.FlashProperty_BackgroundColor = -1;
            this.f_in_box__control1.FlashProperty_Base = "";
            this.f_in_box__control1.FlashProperty_BGColor = "";
            this.f_in_box__control1.FlashProperty_DeviceFont = false;
            this.f_in_box__control1.FlashProperty_EmbedMovie = false;
            this.f_in_box__control1.FlashProperty_FlashVars = "";
            this.f_in_box__control1.FlashProperty_FrameNum = -1;
            this.f_in_box__control1.FlashProperty_Loop = true;
            this.f_in_box__control1.FlashProperty_Menu = true;
            this.f_in_box__control1.FlashProperty_Movie = "";
            this.f_in_box__control1.FlashProperty_MovieData = "";
            this.f_in_box__control1.FlashProperty_Playing = true;
            this.f_in_box__control1.FlashProperty_Quality = 1;
            this.f_in_box__control1.FlashProperty_Quality2 = "High";
            this.f_in_box__control1.FlashProperty_SAlign = "";
            this.f_in_box__control1.FlashProperty_Scale = "ShowAll";
            this.f_in_box__control1.FlashProperty_ScaleMode = 0;
            this.f_in_box__control1.FlashProperty_Stacking = "";
            this.f_in_box__control1.FlashProperty_SWRemote = "";
            this.f_in_box__control1.FlashProperty_WMode = "Window";
            this.f_in_box__control1.Location = new System.Drawing.Point(8, 8);
            this.f_in_box__control1.Name = "f_in_box__control1";
            this.f_in_box__control1.Size = new System.Drawing.Size(616, 339);
            this.f_in_box__control1.StandardMenu = false;
            this.f_in_box__control1.TabIndex = 18;
            this.f_in_box__control1.Text = "f_in_box__control1";
            this.f_in_box__control1.TransparentMode = false;
            this.f_in_box__control1.UseFlashCursor = true;
            this.f_in_box__control1.OnFlashCall += new f_in_box__lib.f_in_box__control.OnFlashCallEventHandler(this.f_in_box__control1_OnFlashCall);
            // 
            // checkBoxPlayAutomatically
            // 
            this.checkBoxPlayAutomatically.Checked = true;
            this.checkBoxPlayAutomatically.CheckState = System.Windows.Forms.CheckState.Checked;
            this.checkBoxPlayAutomatically.Location = new System.Drawing.Point(495, 353);
            this.checkBoxPlayAutomatically.Name = "checkBoxPlayAutomatically";
            this.checkBoxPlayAutomatically.Size = new System.Drawing.Size(120, 24);
            this.checkBoxPlayAutomatically.TabIndex = 21;
            this.checkBoxPlayAutomatically.Text = "Play automatically";
            // 
            // trackBarVideoPosition
            // 
            this.trackBarVideoPosition.Location = new System.Drawing.Point(8, 353);
            this.trackBarVideoPosition.Name = "trackBarVideoPosition";
            this.trackBarVideoPosition.Size = new System.Drawing.Size(481, 45);
            this.trackBarVideoPosition.TabIndex = 22;
            // 
            // buttonBack
            // 
            this.buttonBack.Location = new System.Drawing.Point(318, 404);
            this.buttonBack.Name = "buttonBack";
            this.buttonBack.Size = new System.Drawing.Size(64, 23);
            this.buttonBack.TabIndex = 10;
            this.buttonBack.Text = "Back";
            this.buttonBack.Click += new System.EventHandler(this.buttonBack_Click);
            // 
            // buttonForward
            // 
            this.buttonForward.Location = new System.Drawing.Point(388, 404);
            this.buttonForward.Name = "buttonForward";
            this.buttonForward.Size = new System.Drawing.Size(64, 23);
            this.buttonForward.TabIndex = 10;
            this.buttonForward.Text = "Forward";
            this.buttonForward.Click += new System.EventHandler(this.buttonForward_Click);
            // 
            // MainForm
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(632, 525);
            this.Controls.Add(this.trackBarVideoPosition);
            this.Controls.Add(this.LabelInfo);
            this.Controls.Add(this.checkBoxPlayAutomatically);
            this.Controls.Add(this.f_in_box__control1);
            this.Controls.Add(this.checkBoxShowControls);
            this.Controls.Add(this.labelSoundVolume);
            this.Controls.Add(this.trackBarSoundVolume);
            this.Controls.Add(this.ButtonPlayFLV);
            this.Controls.Add(this.CheckBoxEnableSounds);
            this.Controls.Add(this.ButtonOrder);
            this.Controls.Add(this.ButtonAbout);
            this.Controls.Add(this.buttonPlay);
            this.Controls.Add(this.buttonBack);
            this.Controls.Add(this.buttonForward);
            this.Controls.Add(this.buttonPause);
            this.MaximizeBox = false;
            this.Name = "MainForm";
            this.Text = "Sample 8 - Advanced FLV Player";
            this.Load += new System.EventHandler(this.MainForm_Load);
            ((System.ComponentModel.ISupportInitialize)(this.trackBarSoundVolume)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.timer1)).EndInit();
            this.contextMenuFLV.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.trackBarVideoPosition)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

        private static string BuildFlashVars(string TypeVideo, string URL, bool Mute, int AudioVolume, bool AutoPlay, bool ShowControls)
        {
            string strFlashVars = "type_video=" + TypeVideo;

            strFlashVars += "&url=" + System.Web.HttpUtility.HtmlEncode(URL);

            strFlashVars += "&auto_play=" + (AutoPlay ? "true" : "false");

            // Specify mute=1 to disable audio, don't specify mute at all to enable audio
            if (Mute) strFlashVars += "&mute=1";

            strFlashVars = strFlashVars + "&volume=" + AudioVolume.ToString();

            strFlashVars += "&auto_play=" + (AutoPlay ? "true" : "false");
            strFlashVars += "&hide_control=" + (ShowControls ? "false" : "true");

            return strFlashVars;
        }

        private void PlaySource(string TypeVideo, string URL)
        {
            f_in_box__control1.FlashProperty_FlashVars = BuildFlashVars(TypeVideo, URL, !CheckBoxEnableSounds.Checked, trackBarSoundVolume.Value, checkBoxPlayAutomatically.Checked, checkBoxShowControls.Checked);
            f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample08_Advanced_FLV_Player.res.FlashVideoPlayer.swf"));
        }

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			openFileDialogFlashFile.InitialDirectory = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
			
            PlaySource("flv", "");

            f_in_box__control1.FlashProperty_AllowFullscreen = true;
		}

		private void CheckBoxEnableSounds_CheckedChanged(object sender, System.EventArgs e)
		{
            f_in_box__control1.FlashMethod_CallFunction("<invoke name=\"setMute\" returntype=\"xml\"><arguments>" + (CheckBoxEnableSounds.Checked ? "<false />" : "<true />") + "</arguments></invoke>");

            if (CheckBoxEnableSounds.Checked)
                labelSoundVolume.Text = trackBarSoundVolume.Value.ToString() + " %";
			else
				labelSoundVolume.Text = "Disabled";

            trackBarSoundVolume.Enabled = CheckBoxEnableSounds.Checked;
		}

		private void ButtonAbout_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/");
		}

		private void ButtonOrder_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/order.html");
		}

		private void trackBarSoundVolume_Scroll(object sender, System.EventArgs e)
		{
            f_in_box__control1.FlashMethod_CallFunction("<invoke name=\"setVolume\" returntype=\"xml\"><arguments><number>" + trackBarSoundVolume.Value.ToString() + "</number></arguments></invoke>");

            labelSoundVolume.Text = trackBarSoundVolume.Value.ToString() + " %";
		}

		private void ButtonPlayFLV_Click(object sender, System.EventArgs e)
		{
            Control control = (Control)sender;
            contextMenuFLV.Show(control, new Point(0, control.Height));
		}

		private void buttonPause_Click(object sender, System.EventArgs e)
		{
            f_in_box__control1.FlashMethod_CallFunction("<invoke name=\"pauseVideo\" returntype=\"void\"><arguments></arguments></invoke>");
        }

		private void buttonPlay_Click(object sender, System.EventArgs e)
		{
            f_in_box__control1.FlashMethod_CallFunction("<invoke name=\"resumeVideo\" returntype=\"void\"><arguments></arguments></invoke>");
        }

		private void checkBoxShowControls_CheckedChanged(object sender, System.EventArgs e)
		{
            if (checkBoxShowControls.Checked)
                f_in_box__control1.FlashMethod_CallFunction("<invoke name=\"showAllControl\" returntype=\"void\"><arguments></arguments></invoke>");
            else
                f_in_box__control1.FlashMethod_CallFunction("<invoke name=\"hideAllControl\" returntype=\"void\"><arguments></arguments></invoke>");
		}

        private float GetCurrentVideoPosition()
        {
            string strXMLPosition = f_in_box__control1.FlashMethod_CallFunction("<invoke name=\"getCurrPosition\" returntype=\"xml\"><arguments></arguments></invoke>");
            XmlDocument doc = new XmlDocument();
            doc.LoadXml(strXMLPosition);
            System.Globalization.NumberFormatInfo NumberFormatInfo = new System.Globalization.NumberFormatInfo();
            NumberFormatInfo.NumberDecimalSeparator = ".";
            return float.Parse(doc.DocumentElement.InnerText, NumberFormatInfo);
        }

        private void timer1_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
            float Position = GetCurrentVideoPosition();

            if (-1 != Position)
            {
                trackBarVideoPosition.Value = (int)Position;
                LabelInfo.Text = "Current time: " + ((int)Position).ToString() + " s " + ((int)((Position - (int)Position) * 100)).ToString() + " ms";
            }
        }

        private void playFLVFromFileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialogFlashFile.ShowDialog() == DialogResult.OK)
                PlaySource("flv", openFileDialogFlashFile.FileName);
        }

        private void playFLVEmbeddedInTheApplicationPlayDirectlyWithoutTemporaryFilesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            PlaySource("flv", "http://FLV/FlashVideo.flv");

            Stream FromStream = this.GetType().Assembly.GetManifestResourceStream("Sample08_Advanced_FLV_Player.res.flashvideo.flv");
            ContentProvider ContentProvider =
                new ContentProvider(f_in_box__control1.AxCode, FromStream);
        }

        private void f_in_box__control1_OnFlashCall(object sender, string request)
        {
            f_in_box__lib.f_in_box__control f_in_box__control = (f_in_box__lib.f_in_box__control)sender;
            XmlDocument doc = new XmlDocument();
            doc.LoadXml(request);

            string strRequestName = doc.DocumentElement.Attributes["name"].Value;

            switch (strRequestName)
            {
                case "onMetaData":
                    // Metadata (i.e. information about video) available
                {
                    string strXMLDuration = f_in_box__control.FlashMethod_CallFunction("<invoke name=\"getDuration\" returntype=\"xml\"><arguments></arguments></invoke>");
                    XmlDocument doc1 = new XmlDocument();
                    doc1.LoadXml(strXMLDuration);
                    System.Globalization.NumberFormatInfo NumberFormatInfo = new System.Globalization.NumberFormatInfo();
                    NumberFormatInfo.NumberDecimalSeparator = ".";
                    float Duration = float.Parse(doc1.DocumentElement.InnerText, NumberFormatInfo);

                    trackBarVideoPosition.Maximum = (int)Duration;
                    trackBarVideoPosition.Minimum = 0;
                    
                    break;
                }

                case "onVideoStatus":
                {
                    string strVideoStatus = doc.DocumentElement.ChildNodes[0].ChildNodes[0].InnerText;

                    break;
                }
            }
        }

        private void playFLVFromURLToolStripMenuItem_Click(object sender, EventArgs e)
        {
            URLForm UrlForm = new URLForm();

            if (UrlForm.ShowDialog() == DialogResult.OK)
            {
                f_in_box__control1.FlashProperty_FlashVars = @"type_video=flv&url=" + UrlForm.URL + "&auto_play=" + (checkBoxPlayAutomatically.Checked ? "true" : "false");
                f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample08_Advanced_FLV_Player.res.FlashVideoPlayer.swf"));
            }
        }

        private void playFLVFromRTMPSourceToolStripMenuItem_Click(object sender, EventArgs e)
        {
            URLForm UrlForm = new URLForm();

            if (UrlForm.ShowDialog() == DialogResult.OK)
                PlaySource("rtmp", UrlForm.URL);
        }

        private void buttonBack_Click(object sender, EventArgs e)
        {
            float NewCurrentPosition = GetCurrentVideoPosition() - 5;

            if (NewCurrentPosition < 0)
                NewCurrentPosition = 0;

            f_in_box__control1.FlashMethod_CallFunction("<invoke name=\"seekVideo\" returntype=\"xml\"><arguments><number>" + ((int)NewCurrentPosition).ToString() + "</number></arguments></invoke>");
        }

        private void buttonForward_Click(object sender, EventArgs e)
        {
            float NewCurrentPosition = GetCurrentVideoPosition() + 5;

            f_in_box__control1.FlashMethod_CallFunction("<invoke name=\"seekVideo\" returntype=\"xml\"><arguments><number>" + ((int)NewCurrentPosition).ToString() + "</number></arguments></invoke>");
        }
	}

	class FromStreamToStreamWriter
	{
		internal System.IO.Stream FromStream, ToStream;
		internal System.Threading.Thread Thread;

		public FromStreamToStreamWriter(System.IO.Stream FromStream, System.IO.Stream ToStream)
		{
			this.FromStream = FromStream;
			this.ToStream = ToStream;

			Thread = new System.Threading.Thread(new System.Threading.ThreadStart(Main));

			Thread.Start();
		}

		private void Main()
		{
			const int nSize = 64 * 1024;
			byte[] buffer = new byte[nSize];

			int nReadBytes;

			while (true)
			{
				nReadBytes = FromStream.Read(buffer, 0, nSize);

				if (0 == nReadBytes)
					break;

				try
				{
					ToStream.Write(buffer, 0, nReadBytes);
				}
				catch (System.IO.IOException /* e */ )
				{
					// Loading is interrupted
					break;
				}
			}

			FromStream.Close();
			ToStream.Close();
		}
	}

	class ContentProvider
	{
		private Stream FromStream;
		private f_in_box__lib.AxCode AxCode;
		private f_in_box__lib.AxCode.OnLoadExternalResourceByFullPathEventHandler Handler;

		public ContentProvider(f_in_box__lib.AxCode AxCode, Stream FromStream)
		{
			this.FromStream = FromStream;
			this.AxCode = AxCode;

			Handler = new f_in_box__lib.AxCode.OnLoadExternalResourceByFullPathEventHandler(OnLoadExternalResourceByFullPath);

			AxCode.OnLoadExternalResourceByFullPath += Handler;
		}

		private void OnLoadExternalResourceByFullPath(object sender, String URL, System.IO.Stream Stream, ref bool Handled)
		{
			if (URL == "http://FLV/FlashVideo.flv")
			{
				FromStreamToStreamWriter writer = 
					new FromStreamToStreamWriter(
						FromStream, 
						Stream
					);

				Handled = true;

				AxCode.OnLoadExternalResourceByFullPath -= Handler;
			}
		}
	}
}
