using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Sample06_ExternalResourcesEmbedding
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button MoreAboutComponentButton;
		internal System.Windows.Forms.Button OrderButton;
		internal System.Windows.Forms.OpenFileDialog OpenJPEGFileDialog;
		internal System.Windows.Forms.Label Label1;
		internal System.Windows.Forms.Label Label2;
		private f_in_box__lib.f_in_box__control f_in_box__control1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.MoreAboutComponentButton = new System.Windows.Forms.Button();
			this.OrderButton = new System.Windows.Forms.Button();
			this.OpenJPEGFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.Label1 = new System.Windows.Forms.Label();
			this.Label2 = new System.Windows.Forms.Label();
			this.f_in_box__control1 = new f_in_box__lib.f_in_box__control();
			this.SuspendLayout();
			// 
			// MoreAboutComponentButton
			// 
			this.MoreAboutComponentButton.Location = new System.Drawing.Point(272, 408);
			this.MoreAboutComponentButton.Name = "MoreAboutComponentButton";
			this.MoreAboutComponentButton.Size = new System.Drawing.Size(176, 24);
			this.MoreAboutComponentButton.TabIndex = 8;
			this.MoreAboutComponentButton.Text = "More about F-IN-BOX";
			this.MoreAboutComponentButton.Click += new System.EventHandler(this.MoreAboutComponentButton_Click);
			// 
			// OrderButton
			// 
			this.OrderButton.Location = new System.Drawing.Point(456, 408);
			this.OrderButton.Name = "OrderButton";
			this.OrderButton.Size = new System.Drawing.Size(168, 24);
			this.OrderButton.TabIndex = 5;
			this.OrderButton.Text = "Buy license";
			this.OrderButton.Click += new System.EventHandler(this.OrderButton_Click);
			// 
			// OpenJPEGFileDialog
			// 
			this.OpenJPEGFileDialog.Filter = "JPEG Files (*.jpg, *.jpeg)|*.jpg;*.jpeg|All Files (*.*)|*.*";
			// 
			// Label1
			// 
			this.Label1.Location = new System.Drawing.Point(8, 8);
			this.Label1.Name = "Label1";
			this.Label1.Size = new System.Drawing.Size(616, 32);
			this.Label1.TabIndex = 11;
			this.Label1.Text = "The movie loads each image using a relative path. The application provides conten" +
				"t of the images. All images are loading from System.IO.Stream. Click \"Load exter" +
				"nal image...\" to load image from external file.";
			// 
			// Label2
			// 
			this.Label2.Location = new System.Drawing.Point(8, 40);
			this.Label2.Name = "Label2";
			this.Label2.Size = new System.Drawing.Size(616, 32);
			this.Label2.TabIndex = 10;
			this.Label2.Text = "The application uses the event OnLoadExternalResourceByRelativePath. This event i" +
				"s called when a movie tries to load an external resource (xml, jpeg, mp3, etc.) " +
				"using a relative path. Provide a content by handling the event.";
			// 
			// f_in_box__control1
			// 
			this.f_in_box__control1.FlashProperty_AlignMode = 0;
			this.f_in_box__control1.FlashProperty_AllowScriptAccess = "";
			this.f_in_box__control1.FlashProperty_BackgroundColor = -1;
			this.f_in_box__control1.FlashProperty_Base = "";
			this.f_in_box__control1.FlashProperty_BGColor = "";
			this.f_in_box__control1.FlashProperty_DeviceFont = false;
			this.f_in_box__control1.FlashProperty_EmbedMovie = false;
			this.f_in_box__control1.FlashProperty_FlashVars = "";
			this.f_in_box__control1.FlashProperty_FrameNum = -1;
			this.f_in_box__control1.FlashProperty_Loop = true;
			this.f_in_box__control1.FlashProperty_Menu = true;
			this.f_in_box__control1.FlashProperty_Movie = "";
			this.f_in_box__control1.FlashProperty_MovieData = "";
			this.f_in_box__control1.FlashProperty_Playing = true;
			this.f_in_box__control1.FlashProperty_Quality = 1;
			this.f_in_box__control1.FlashProperty_Quality2 = "High";
			this.f_in_box__control1.FlashProperty_SAlign = "";
			this.f_in_box__control1.FlashProperty_Scale = "ShowAll";
			this.f_in_box__control1.FlashProperty_ScaleMode = 0;
			this.f_in_box__control1.FlashProperty_Stacking = "";
			this.f_in_box__control1.FlashProperty_SWRemote = "";
			this.f_in_box__control1.FlashProperty_WMode = "Window";
			this.f_in_box__control1.Location = new System.Drawing.Point(8, 72);
			this.f_in_box__control1.Name = "f_in_box__control1";
			this.f_in_box__control1.Size = new System.Drawing.Size(616, 320);
			this.f_in_box__control1.StandardMenu = false;
			this.f_in_box__control1.TabIndex = 12;
			this.f_in_box__control1.Text = "f_in_box__control1";
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(632, 446);
			this.Controls.Add(this.f_in_box__control1);
			this.Controls.Add(this.Label1);
			this.Controls.Add(this.Label2);
			this.Controls.Add(this.MoreAboutComponentButton);
			this.Controls.Add(this.OrderButton);
			this.MaximizeBox = false;
			this.Name = "MainForm";
			this.Text = "Sample 6 - external resources embedding";
			this.Load += new System.EventHandler(this.MainForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			f_in_box__control1.OnLoadExternalResourceByRelativePath += 
				new f_in_box__lib.f_in_box__control.OnLoadExternalResourceByRelativePathEventHandler(OnLoadExternalResourceByRelativePath);

			OpenJPEGFileDialog.InitialDirectory = System.IO.Path.GetDirectoryName(Application.ExecutablePath);

			f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample06_ExternalResourcesEmbedding.Resources.load_images.swf"));
			f_in_box__control1.FlashMethod_Play();
		}

		private void OnLoadExternalResourceByRelativePath(object sender, String strRelativePath, System.IO.Stream Stream, ref bool Handled)
		{
			System.IO.Stream FromStream = null;

			if (strRelativePath == "images/embedded_image1.jpg")
				FromStream = this.GetType().Assembly.GetManifestResourceStream("Sample06_ExternalResourcesEmbedding.Resources.embedded_images.embedded_image1.jpg");
			if (strRelativePath == "images/embedded_image2.jpg")
				FromStream = this.GetType().Assembly.GetManifestResourceStream("Sample06_ExternalResourcesEmbedding.Resources.embedded_images.embedded_image2.jpg");
			if (strRelativePath == "images/embedded_image3.jpg")
				FromStream = this.GetType().Assembly.GetManifestResourceStream("Sample06_ExternalResourcesEmbedding.Resources.embedded_images.embedded_image3.jpg");
			if (strRelativePath == "images/embedded_image4.jpg")
				FromStream = this.GetType().Assembly.GetManifestResourceStream("Sample06_ExternalResourcesEmbedding.Resources.embedded_images.embedded_image4.jpg");
			if (strRelativePath == "images/embedded_image5.jpg")
				FromStream = this.GetType().Assembly.GetManifestResourceStream("Sample06_ExternalResourcesEmbedding.Resources.embedded_images.embedded_image5.jpg");
			if (strRelativePath == "images/external_image.jpg")
			{
				if (OpenJPEGFileDialog.ShowDialog() == DialogResult.OK)
					FromStream = OpenJPEGFileDialog.OpenFile();
			}

			if (FromStream != null)
			{
				const int size = 64 * 1024;
				byte[] buffer = new byte[size];
				int ReadBytes;

				while ( (ReadBytes = FromStream.Read(buffer, 0, size)) > 0 )
				{
					try
					{
						Stream.Write(buffer, 0, size);
					}
					catch (System.IO.IOException /* e */ )
					{
						// Loading is interrupted
						break;
					}
				}

				Stream.Close();

				Handled = true;
			}
		}

		private void MoreAboutComponentButton_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/");
		}

		private void OrderButton_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/order.html");
		}
	}
}
