using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Sample05_SWF2Bitmap
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button PlaySWFFromFileButton;
		internal System.Windows.Forms.OpenFileDialog OpenSWFFileDialog;
		internal System.Windows.Forms.Button MoreAboutComponentButton;
		internal System.Windows.Forms.SaveFileDialog SaveBMPFileDialog;
		internal System.Windows.Forms.Button OrderButton;
		internal System.Windows.Forms.Button SaveFrameButton;
		private f_in_box__lib.f_in_box__control f_in_box__control1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.PlaySWFFromFileButton = new System.Windows.Forms.Button();
			this.OpenSWFFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.MoreAboutComponentButton = new System.Windows.Forms.Button();
			this.SaveBMPFileDialog = new System.Windows.Forms.SaveFileDialog();
			this.OrderButton = new System.Windows.Forms.Button();
			this.SaveFrameButton = new System.Windows.Forms.Button();
			this.f_in_box__control1 = new f_in_box__lib.f_in_box__control();
			this.SuspendLayout();
			// 
			// PlaySWFFromFileButton
			// 
			this.PlaySWFFromFileButton.Location = new System.Drawing.Point(8, 376);
			this.PlaySWFFromFileButton.Name = "PlaySWFFromFileButton";
			this.PlaySWFFromFileButton.Size = new System.Drawing.Size(128, 24);
			this.PlaySWFFromFileButton.TabIndex = 7;
			this.PlaySWFFromFileButton.Text = "Play SWF from file...";
			this.PlaySWFFromFileButton.Click += new System.EventHandler(this.PlaySWFFromFileButton_Click);
			// 
			// OpenSWFFileDialog
			// 
			this.OpenSWFFileDialog.Filter = "Flash Movies (*.swf)|*.swf|All Files (*.*)|*.*";
			// 
			// MoreAboutComponentButton
			// 
			this.MoreAboutComponentButton.Location = new System.Drawing.Point(480, 376);
			this.MoreAboutComponentButton.Name = "MoreAboutComponentButton";
			this.MoreAboutComponentButton.Size = new System.Drawing.Size(144, 24);
			this.MoreAboutComponentButton.TabIndex = 8;
			this.MoreAboutComponentButton.Text = "More about F-IN-BOX";
			this.MoreAboutComponentButton.Click += new System.EventHandler(this.MoreAboutComponentButton_Click);
			// 
			// SaveBMPFileDialog
			// 
			this.SaveBMPFileDialog.Filter = "Bitmap Files (*.bmp)|*.bmp|All Files (*.*)|*.*";
			// 
			// OrderButton
			// 
			this.OrderButton.Location = new System.Drawing.Point(480, 408);
			this.OrderButton.Name = "OrderButton";
			this.OrderButton.Size = new System.Drawing.Size(144, 24);
			this.OrderButton.TabIndex = 5;
			this.OrderButton.Text = "Buy license";
			this.OrderButton.Click += new System.EventHandler(this.OrderButton_Click);
			// 
			// SaveFrameButton
			// 
			this.SaveFrameButton.Location = new System.Drawing.Point(144, 376);
			this.SaveFrameButton.Name = "SaveFrameButton";
			this.SaveFrameButton.Size = new System.Drawing.Size(184, 24);
			this.SaveFrameButton.TabIndex = 6;
			this.SaveFrameButton.Text = "Save frame as bitmap...";
			this.SaveFrameButton.Click += new System.EventHandler(this.SaveFrameButton_Click);
			// 
			// f_in_box__control1
			// 
			this.f_in_box__control1.FlashProperty_AlignMode = 0;
			this.f_in_box__control1.FlashProperty_AllowScriptAccess = "";
			this.f_in_box__control1.FlashProperty_BackgroundColor = -1;
			this.f_in_box__control1.FlashProperty_Base = "";
			this.f_in_box__control1.FlashProperty_BGColor = "";
			this.f_in_box__control1.FlashProperty_DeviceFont = false;
			this.f_in_box__control1.FlashProperty_EmbedMovie = false;
			this.f_in_box__control1.FlashProperty_FlashVars = "";
			this.f_in_box__control1.FlashProperty_FrameNum = -1;
			this.f_in_box__control1.FlashProperty_Loop = true;
			this.f_in_box__control1.FlashProperty_Menu = true;
			this.f_in_box__control1.FlashProperty_Movie = "";
			this.f_in_box__control1.FlashProperty_MovieData = "";
			this.f_in_box__control1.FlashProperty_Playing = true;
			this.f_in_box__control1.FlashProperty_Quality = 1;
			this.f_in_box__control1.FlashProperty_Quality2 = "High";
			this.f_in_box__control1.FlashProperty_SAlign = "";
			this.f_in_box__control1.FlashProperty_Scale = "ShowAll";
			this.f_in_box__control1.FlashProperty_ScaleMode = 0;
			this.f_in_box__control1.FlashProperty_Stacking = "";
			this.f_in_box__control1.FlashProperty_SWRemote = "";
			this.f_in_box__control1.FlashProperty_WMode = "Window";
			this.f_in_box__control1.Location = new System.Drawing.Point(8, 8);
			this.f_in_box__control1.Name = "f_in_box__control1";
			this.f_in_box__control1.Size = new System.Drawing.Size(616, 360);
			this.f_in_box__control1.StandardMenu = false;
			this.f_in_box__control1.TabIndex = 9;
			this.f_in_box__control1.Text = "f_in_box__control1";
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(632, 446);
			this.Controls.Add(this.f_in_box__control1);
			this.Controls.Add(this.MoreAboutComponentButton);
			this.Controls.Add(this.OrderButton);
			this.Controls.Add(this.SaveFrameButton);
			this.Controls.Add(this.PlaySWFFromFileButton);
			this.MaximizeBox = false;
			this.Name = "MainForm";
			this.Text = "Sample 5 - Saving Frame As Bitmap";
			this.Load += new System.EventHandler(this.MainForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			OpenSWFFileDialog.InitialDirectory = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
			SaveBMPFileDialog.InitialDirectory = System.IO.Path.GetDirectoryName(Application.ExecutablePath);

			f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample05_SWF2Bitmap.Embedded_Movies.movie.swf"));
			f_in_box__control1.FlashMethod_Play();
		}

		private void PlaySWFFromFileButton_Click(object sender, System.EventArgs e)
		{
			if (OpenSWFFileDialog.ShowDialog() == DialogResult.OK)
				f_in_box__control1.FlashProperty_Movie = OpenSWFFileDialog.FileName;
		}

		private void SaveFrameButton_Click(object sender, System.EventArgs e)
		{
	        Bitmap FrameBitmap = f_in_box__control1.GetBitmap();

			if (SaveBMPFileDialog.ShowDialog() == DialogResult.OK)
			{
	            FrameBitmap.Save(SaveBMPFileDialog.FileName, System.Drawing.Imaging.ImageFormat.Bmp);

				if (DialogResult.Yes == 
					MessageBox.Show("Would you like to open saved image?", "Question", MessageBoxButtons.YesNo))
					System.Diagnostics.Process.Start(SaveBMPFileDialog.FileName);
			}
		}

		private void MoreAboutComponentButton_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/");
		}

		private void OrderButton_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/order.html");
		}
	}
}
