using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Sample02_SWF_FLV_Embedding
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button ButtonOrder;
		internal System.Windows.Forms.Button ButtonAbout;
		internal System.Windows.Forms.Button ButtonPlayFLV;
		internal System.Windows.Forms.Button ButtonPlaySWF;
		internal System.Windows.Forms.CheckBox CheckBoxEnableSounds;
		internal System.Windows.Forms.CheckBox CheckBoxEnableStandardContextMenu;
		private f_in_box__lib.f_in_box__control f_in_box__control1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.ButtonOrder = new System.Windows.Forms.Button();
			this.ButtonAbout = new System.Windows.Forms.Button();
			this.ButtonPlayFLV = new System.Windows.Forms.Button();
			this.ButtonPlaySWF = new System.Windows.Forms.Button();
			this.CheckBoxEnableSounds = new System.Windows.Forms.CheckBox();
			this.CheckBoxEnableStandardContextMenu = new System.Windows.Forms.CheckBox();
			this.f_in_box__control1 = new f_in_box__lib.f_in_box__control();
			this.SuspendLayout();
			// 
			// ButtonOrder
			// 
			this.ButtonOrder.Location = new System.Drawing.Point(448, 408);
			this.ButtonOrder.Name = "ButtonOrder";
			this.ButtonOrder.Size = new System.Drawing.Size(176, 23);
			this.ButtonOrder.TabIndex = 13;
			this.ButtonOrder.Text = "Buy license";
			this.ButtonOrder.Click += new System.EventHandler(this.ButtonOrder_Click);
			// 
			// ButtonAbout
			// 
			this.ButtonAbout.Location = new System.Drawing.Point(448, 376);
			this.ButtonAbout.Name = "ButtonAbout";
			this.ButtonAbout.Size = new System.Drawing.Size(176, 23);
			this.ButtonAbout.TabIndex = 12;
			this.ButtonAbout.Text = "More about F-IN-BOX";
			this.ButtonAbout.Click += new System.EventHandler(this.ButtonAbout_Click);
			// 
			// ButtonPlayFLV
			// 
			this.ButtonPlayFLV.Location = new System.Drawing.Point(136, 408);
			this.ButtonPlayFLV.Name = "ButtonPlayFLV";
			this.ButtonPlayFLV.Size = new System.Drawing.Size(120, 23);
			this.ButtonPlayFLV.TabIndex = 11;
			this.ButtonPlayFLV.Text = "Play embedded FLV";
			this.ButtonPlayFLV.Click += new System.EventHandler(this.ButtonPlayFLV_Click);
			// 
			// ButtonPlaySWF
			// 
			this.ButtonPlaySWF.Location = new System.Drawing.Point(8, 408);
			this.ButtonPlaySWF.Name = "ButtonPlaySWF";
			this.ButtonPlaySWF.Size = new System.Drawing.Size(120, 23);
			this.ButtonPlaySWF.TabIndex = 10;
			this.ButtonPlaySWF.Text = "Play embedded SWF";
			this.ButtonPlaySWF.Click += new System.EventHandler(this.ButtonPlaySWF_Click);
			// 
			// CheckBoxEnableSounds
			// 
			this.CheckBoxEnableSounds.Location = new System.Drawing.Point(208, 376);
			this.CheckBoxEnableSounds.Name = "CheckBoxEnableSounds";
			this.CheckBoxEnableSounds.TabIndex = 9;
			this.CheckBoxEnableSounds.Text = "Enable Sounds";
			this.CheckBoxEnableSounds.CheckedChanged += new System.EventHandler(this.CheckBoxEnableSounds_CheckedChanged);
			// 
			// CheckBoxEnableStandardContextMenu
			// 
			this.CheckBoxEnableStandardContextMenu.Location = new System.Drawing.Point(8, 376);
			this.CheckBoxEnableStandardContextMenu.Name = "CheckBoxEnableStandardContextMenu";
			this.CheckBoxEnableStandardContextMenu.Size = new System.Drawing.Size(184, 24);
			this.CheckBoxEnableStandardContextMenu.TabIndex = 8;
			this.CheckBoxEnableStandardContextMenu.Text = "Enable Standard Context Menu";
			this.CheckBoxEnableStandardContextMenu.CheckedChanged += new System.EventHandler(this.CheckBoxEnableStandardContextMenu_CheckedChanged);
			// 
			// f_in_box__control1
			// 
			this.f_in_box__control1.FlashProperty_AlignMode = 0;
			this.f_in_box__control1.FlashProperty_AllowScriptAccess = "";
			this.f_in_box__control1.FlashProperty_BackgroundColor = -1;
			this.f_in_box__control1.FlashProperty_Base = "";
			this.f_in_box__control1.FlashProperty_BGColor = "";
			this.f_in_box__control1.FlashProperty_DeviceFont = false;
			this.f_in_box__control1.FlashProperty_EmbedMovie = false;
			this.f_in_box__control1.FlashProperty_FlashVars = "";
			this.f_in_box__control1.FlashProperty_FrameNum = -1;
			this.f_in_box__control1.FlashProperty_Loop = true;
			this.f_in_box__control1.FlashProperty_Menu = true;
			this.f_in_box__control1.FlashProperty_Movie = "";
			this.f_in_box__control1.FlashProperty_MovieData = "";
			this.f_in_box__control1.FlashProperty_Playing = true;
			this.f_in_box__control1.FlashProperty_Quality = 1;
			this.f_in_box__control1.FlashProperty_Quality2 = "High";
			this.f_in_box__control1.FlashProperty_SAlign = "";
			this.f_in_box__control1.FlashProperty_Scale = "ShowAll";
			this.f_in_box__control1.FlashProperty_ScaleMode = 0;
			this.f_in_box__control1.FlashProperty_Stacking = "";
			this.f_in_box__control1.FlashProperty_SWRemote = "";
			this.f_in_box__control1.FlashProperty_WMode = "Window";
			this.f_in_box__control1.Location = new System.Drawing.Point(8, 8);
			this.f_in_box__control1.Name = "f_in_box__control1";
			this.f_in_box__control1.Size = new System.Drawing.Size(616, 360);
			this.f_in_box__control1.StandardMenu = false;
			this.f_in_box__control1.TabIndex = 14;
			this.f_in_box__control1.Text = "f_in_box__control1";
			this.f_in_box__control1.OnReadyStateChange += new f_in_box__lib.f_in_box__control.OnReadyStateChangeEventHandler(this.f_in_box__control1_OnReadyStateChange);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(632, 446);
			this.Controls.Add(this.f_in_box__control1);
			this.Controls.Add(this.ButtonOrder);
			this.Controls.Add(this.ButtonAbout);
			this.Controls.Add(this.ButtonPlayFLV);
			this.Controls.Add(this.ButtonPlaySWF);
			this.Controls.Add(this.CheckBoxEnableSounds);
			this.Controls.Add(this.CheckBoxEnableStandardContextMenu);
			this.MaximizeBox = false;
			this.Name = "MainForm";
			this.Text = "Sample 2 - SWF Embedding and FLV Embedding";
			this.Load += new System.EventHandler(this.MainForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			f_in_box__control1.AxCode.OnLoadExternalResourceByFullPath += 
				new f_in_box__lib.AxCode.OnLoadExternalResourceByFullPathEventHandler(OnLoadExternalResourceByFullPath);

			CheckBoxEnableStandardContextMenu.Checked = f_in_box__control1.StandardMenu;
			CheckBoxEnableSounds.Checked = f_in_box__control1.AxCode.SoundEnabled;

			f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample02_SWF_FLV_Embedding.Embedded_Movies.movie.swf"));
			f_in_box__control1.FlashMethod_Play();
		}

		private void ButtonPlaySWF_Click(object sender, System.EventArgs e)
		{
			f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample02_SWF_FLV_Embedding.Embedded_Movies.movie.swf"));
			f_in_box__control1.FlashMethod_Play();
		}

		private void ButtonPlayFLV_Click(object sender, System.EventArgs e)
		{
			f_in_box__control1.FlashProperty_FlashVars = "FLVPath=http://FLV/FlashVideo.flv";
			f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample02_SWF_FLV_Embedding.Embedded_Movies.FLVPlayer.swf"));
			f_in_box__control1.FlashMethod_Play();
		}

		private void CheckBoxEnableStandardContextMenu_CheckedChanged(object sender, System.EventArgs e)
		{
	        f_in_box__control1.StandardMenu = CheckBoxEnableStandardContextMenu.Checked;
		}

		private void CheckBoxEnableSounds_CheckedChanged(object sender, System.EventArgs e)
		{
	        f_in_box__control1.AxCode.SoundEnabled = CheckBoxEnableSounds.Checked;
		}

		private void OnLoadExternalResourceByFullPath(object sender, String URL, System.IO.Stream Stream, ref bool Handled)
		{
			if (URL == "http://FLV/FlashVideo.flv")
			{
				System.IO.Stream FLVStream = this.GetType().Assembly.GetManifestResourceStream("Sample02_SWF_FLV_Embedding.Embedded_Movies.flashvideo.flv");

				FromStreamToStreamWriter writer = 
					new FromStreamToStreamWriter(
					FLVStream, 
					Stream
					);

				Handled = true;
			}
		}

		private void ButtonAbout_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/");
		}

		private void ButtonOrder_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/order.html");
		}

		private void f_in_box__control1_OnReadyStateChange(object sender, f_in_box__lib.f_in_box__control.ReadyState state)
		{
		
		}
	}

	class FromStreamToStreamWriter
	{
		internal System.IO.Stream FromStream, ToStream;
		internal System.Threading.Thread Thread;

		public FromStreamToStreamWriter(System.IO.Stream FromStream, System.IO.Stream ToStream)
		{
			this.FromStream = FromStream;
			this.ToStream = ToStream;

			Thread = new System.Threading.Thread(new System.Threading.ThreadStart(Main));

			Thread.Start();
		}

		private void Main()
		{
			const int nSize = 64 * 1024;
			byte[] buffer = new byte[nSize];

			int nReadBytes;

			while (true)
			{
				nReadBytes = FromStream.Read(buffer, 0, nSize);

				if (0 == nReadBytes)
					break;

				try
				{
					ToStream.Write(buffer, 0, nReadBytes);
				}
				catch (System.IO.IOException /* e */ )
				{
					// Loading is interrupted
					break;
				}
			}

			FromStream.Close();
			ToStream.Close();
		}
	}
}
