Public Class Form1

    Dim EncryptedFLVPath As String
    Dim EncryptedSWFPath As String

    Enum FlashFileType
        SWF
        FLV
    End Enum

    Dim FlashType As FlashFileType

    Private Sub PlayFLV(ByVal URL As String)
        EncryptedFLVPath = URL
        FlashType = FlashFileType.FLV

        f_in_box__control1.FlashProperty_FlashVars = BuildFlashVars("flv", "http://FLV/FlashVideo.flv", Not CheckBoxEnableSounds.Checked, trackBarSoundVolume.Value, checkBoxPlayAutomatically.Checked, checkBoxShowControls.Checked)
        f_in_box__control1.PutMovieFromStream(Me.GetType().Assembly.GetManifestResourceStream("Sample11_Playing_Of_Encrypted_FLV_SWF.FlashVideoPlayer.swf"))
    End Sub

    Private Sub PlaySWF(ByVal URL As String)
        EncryptedSWFPath = URL
        FlashType = FlashFileType.SWF

        f_in_box__control1.FlashMethod_LoadMovie(0, "http://SWF/FlashFile.swf")
    End Sub

    Private Sub ButtonPlayFLV_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPlayFLV.Click
        If openFileDialogEncryptedFLV.ShowDialog = Windows.Forms.DialogResult.OK Then
            PlayFLV(openFileDialogEncryptedFLV.FileName)
        End If
    End Sub

    Private Sub buttonPlay_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonPlay.Click
        f_in_box__control1.FlashMethod_CallFunction("<invoke name=" & """" & "resumeVideo" & """" & " returntype=" & """" & "void" & """" & "><arguments></arguments></invoke>")
    End Sub

    Private Sub buttonPause_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonPause.Click
        f_in_box__control1.FlashMethod_CallFunction("<invoke name=" & """" & "pauseVideo" & """" & " returntype=" & """" & "void" & """" & "><arguments></arguments></invoke>")
    End Sub

    Private Shared Function BuildFlashVars(ByVal TypeVideo As String, ByVal URL As String, ByVal Mute As Boolean, ByVal AudioVolume As Integer, ByVal AutoPlay As Boolean, ByVal ShowControls As Boolean) As String
        BuildFlashVars = "type_video=" + TypeVideo

        BuildFlashVars = BuildFlashVars + "&url=" + System.Web.HttpUtility.HtmlEncode(URL)

        ' Specify mute=1 to disable audio, don't specify mute at all to enable audio
        If Mute Then BuildFlashVars = BuildFlashVars + "&mute=1"

        BuildFlashVars = BuildFlashVars + "&volume=" + AudioVolume.ToString()

        BuildFlashVars = BuildFlashVars + "&auto_play="
        If AutoPlay Then
            BuildFlashVars = BuildFlashVars + "true"
        Else
            BuildFlashVars = BuildFlashVars + "false"
        End If

        BuildFlashVars = BuildFlashVars + "&hide_control="
        If ShowControls Then
            BuildFlashVars = BuildFlashVars + "false"
        Else
            BuildFlashVars = BuildFlashVars + "true"
        End If

    End Function

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        AddHandler f_in_box__control1.AxCode.OnLoadExternalResourceByFullPath, AddressOf OnLoadExternalResourceByFullPath

        openFileDialogFlashFile.InitialDirectory = System.IO.Path.GetDirectoryName(Application.ExecutablePath)

        f_in_box__control1.FlashProperty_AllowFullscreen = True
    End Sub

    Private Sub checkBoxShowControls_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles checkBoxShowControls.CheckedChanged
        If checkBoxShowControls.Checked Then
            f_in_box__control1.FlashMethod_CallFunction("<invoke name=" & """" & "showAllControl" & """" & " returntype=" & """" & "void" & """" & "><arguments></arguments></invoke>")
        Else
            f_in_box__control1.FlashMethod_CallFunction("<invoke name=" & """" & "hideAllControl" & """" & " returntype=" & """" & "void" & """" & "><arguments></arguments></invoke>")
        End If
    End Sub

    Private Function GetCurrentPosition() As Double
        If FlashType = FlashFileType.FLV Then
            Dim strXML As String
            strXML = f_in_box__control1.FlashMethod_CallFunction("<invoke name=" & """" & "getCurrPosition" & """" & "returntype=" & """" & "xml" & """" & "><arguments></arguments></invoke>")
            Dim doc1 As New Xml.XmlDocument
            doc1.LoadXml(strXML)
            Dim NumberFormatInfo As New System.Globalization.NumberFormatInfo
            NumberFormatInfo.NumberDecimalSeparator = "."
            GetCurrentPosition = Double.Parse(doc1.DocumentElement.InnerText, NumberFormatInfo)
        End If
    End Function

    Private Sub buttonBack_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonBack.Click
        Dim CurrentPosition As Double
        CurrentPosition = GetCurrentPosition()

        CurrentPosition = CurrentPosition - 5

        If CurrentPosition < 0 Then CurrentPosition = 0

        Dim CurrentPositionAsInteger As Integer
        CurrentPositionAsInteger = CurrentPosition

        f_in_box__control1.FlashMethod_CallFunction("<invoke name=" & """" & "seekVideo" & """" & " returntype=" & """" & "xml" & """" & "><arguments><number>" + CurrentPositionAsInteger.ToString() + "</number></arguments></invoke>")
    End Sub

    Private Sub OnLoadExternalResourceByFullPath(ByVal sender As Object, ByVal URL As String, ByVal Stream As System.IO.Stream, ByRef Handled As Boolean)
        If URL = "http://FLV/FlashVideo.flv" Then
            Dim EncryptedFLVStream As System.IO.Stream = System.IO.File.OpenRead(EncryptedFLVPath)

            Dim DecryptStreamAndWriteToStream As New DecryptStreamAndWriteToStream(EncryptedFLVStream, Stream)

            Handled = True
        ElseIf URL = "http://SWF/FlashFile.swf" Then
            Dim EncryptedSWFStream As System.IO.Stream = System.IO.File.OpenRead(EncryptedSWFPath)

            Dim DecryptStreamAndWriteToStream As New DecryptStreamAndWriteToStream(EncryptedSWFStream, Stream)

            Handled = True
        End If
    End Sub

    Private Sub buttonForward_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonForward.Click
        Dim CurrentPosition As Double
        CurrentPosition = GetCurrentPosition()

        CurrentPosition = CurrentPosition + 5

        Dim CurrentPositionAsInteger As Integer
        CurrentPositionAsInteger = CurrentPosition

        f_in_box__control1.FlashMethod_CallFunction("<invoke name=" & """" & "seekVideo" & """" & " returntype=" & """" & "xml" & """" & "><arguments><number>" + CurrentPositionAsInteger.ToString() + "</number></arguments></invoke>")
    End Sub

    Private Sub timer1_Elapsed(ByVal sender As System.Object, ByVal e As System.Timers.ElapsedEventArgs) Handles timer1.Elapsed
        Dim CurrentPosition As Double
        CurrentPosition = GetCurrentPosition()

        If CurrentPosition <> -1 Then
            Dim PositionInSeconds As Integer
            PositionInSeconds = CurrentPosition

            trackBarVideoPosition.Value = CurrentPosition

            Dim PositionMS As Integer
            PositionMS = (CurrentPosition * 100) Mod 100

            LabelInfo.Text = "Current time: " + PositionInSeconds.ToString() + " s " + PositionMS.ToString() + " ms"
        End If
    End Sub

    Private Sub CheckBoxEnableSounds_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxEnableSounds.CheckedChanged
        Dim value As String

        If CheckBoxEnableSounds.Checked Then
            value = "<false />"
        Else
            value = "<true />"
        End If

        f_in_box__control1.FlashMethod_CallFunction("<invoke name=" & """" & "setMute" & """" & " returntype=" & """" & "xml" & """" & "><arguments>" + value + "</arguments></invoke>")

        If CheckBoxEnableSounds.Checked Then
            labelSoundVolume.Text = trackBarSoundVolume.Value.ToString() + " %"
        Else
            labelSoundVolume.Text = "Disabled"
        End If

        trackBarSoundVolume.Enabled = CheckBoxEnableSounds.Checked
    End Sub

    Private Sub trackBarSoundVolume_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles trackBarSoundVolume.Scroll
        f_in_box__control1.FlashMethod_CallFunction("<invoke name=" & """" & "setVolume" & """" & " returntype=" & """" & "xml" & """" & "><arguments><number>" + trackBarSoundVolume.Value.ToString() + "</number></arguments></invoke>")

        labelSoundVolume.Text = trackBarSoundVolume.Value.ToString() + " %"
    End Sub

    Private Sub f_in_box__control1_OnFlashCall(ByVal sender As System.Object, ByVal request As System.String) Handles f_in_box__control1.OnFlashCall
        Dim f_in_box__control As f_in_box__lib.f_in_box__control = sender

        Dim doc As New Xml.XmlDocument
        doc.LoadXml(request)

        Dim strRequestName As String = doc.DocumentElement.Attributes("name").Value

        If strRequestName = "onMetaData" Then
            ' Metadata (i.e. information about video) available
            Dim strXMLDuration As String = f_in_box__control.FlashMethod_CallFunction("<invoke name=" & """" & "getDuration" & """" & " returntype=" & """" & "xml" & """" & "><arguments></arguments></invoke>")
            Dim doc1 As New Xml.XmlDocument
            doc1.LoadXml(strXMLDuration)
            Dim NumberFormatInfo As New System.Globalization.NumberFormatInfo
            NumberFormatInfo.NumberDecimalSeparator = "."
            Dim Duration As Double = Double.Parse(doc1.DocumentElement.InnerText, NumberFormatInfo)

            trackBarVideoPosition.Maximum = Duration
            trackBarVideoPosition.Minimum = 0
        ElseIf strRequestName = "onVideoStatus" Then
            Dim strVideoStatus As String = doc.DocumentElement.ChildNodes(0).ChildNodes(0).InnerText
        End If
    End Sub

    Private Sub buttonEncryptFLV_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonEncryptFLV.Click
        If openFileDialogFlashFile.ShowDialog = Windows.Forms.DialogResult.OK Then
            Dim InputStream As System.IO.Stream = System.IO.File.OpenRead(openFileDialogFlashFile.FileName)

            saveFileDialogEncryptedFLV.FileName = openFileDialogFlashFile.FileName + ".eflv"

            If saveFileDialogEncryptedFLV.ShowDialog = Windows.Forms.DialogResult.OK Then

                Dim EncryptedStream As System.IO.Stream = System.IO.File.Create(saveFileDialogEncryptedFLV.FileName)

                Const nSize As Integer = 64 * 1024
                Dim buffer(nSize) As Byte
                Dim i As Integer

                Dim nReadBytes As Integer

                While (True)
                    nReadBytes = InputStream.Read(buffer, 0, nSize)

                    ' Simple decryption
                    For i = 0 To nSize
                        buffer(i) = buffer(i) Xor &H35
                    Next

                    If 0 = nReadBytes Then Exit While

                    EncryptedStream.Write(buffer, 0, nReadBytes)

                End While

                InputStream.Close()
                EncryptedStream.Close()

                If MessageBox.Show("Would like to play the encrypted FLV?", "Question", MessageBoxButtons.OKCancel) = Windows.Forms.DialogResult.OK Then
                    PlayFLV(saveFileDialogEncryptedFLV.FileName)
                End If
            End If
        End If
    End Sub

    Private Sub buttonEncryptSWF_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles buttonEncryptSWF.Click
        If openFileDialogSWF.ShowDialog = Windows.Forms.DialogResult.OK Then
            Dim InputStream As System.IO.Stream = System.IO.File.OpenRead(openFileDialogSWF.FileName)

            saveFileDialogEncryptedSWF.FileName = openFileDialogSWF.FileName + ".eswf"

            If saveFileDialogEncryptedSWF.ShowDialog = Windows.Forms.DialogResult.OK Then

                Dim EncryptedStream As System.IO.Stream = System.IO.File.Create(saveFileDialogEncryptedSWF.FileName)

                Const nSize As Integer = 64 * 1024
                Dim buffer(nSize) As Byte
                Dim i As Integer

                Dim nReadBytes As Integer

                While (True)
                    nReadBytes = InputStream.Read(buffer, 0, nSize)

                    ' Simple decryption
                    For i = 0 To nSize
                        buffer(i) = buffer(i) Xor &H35
                    Next

                    If 0 = nReadBytes Then Exit While

                    EncryptedStream.Write(buffer, 0, nReadBytes)

                End While

                InputStream.Close()
                EncryptedStream.Close()

                If MessageBox.Show("Would like to play the encrypted SWF?", "Question", MessageBoxButtons.OKCancel) = Windows.Forms.DialogResult.OK Then
                    PlaySWF(saveFileDialogEncryptedSWF.FileName)
                End If
            End If
        End If
    End Sub

    Private Sub ButtonPlaySWF_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPlaySWF.Click
        If openFileDialogEncryptedSWF.ShowDialog = Windows.Forms.DialogResult.OK Then
            PlaySWF(openFileDialogEncryptedSWF.FileName)
        End If
    End Sub
End Class

Class DecryptStreamAndWriteToStream
    Private EncryptedStream As System.IO.Stream
    Private OutputStream As System.IO.Stream
    Private Thread As System.Threading.Thread

    Public Sub New(ByVal EncryptedStream As System.IO.Stream, ByVal OutputStream As System.IO.Stream)
        Me.EncryptedStream = EncryptedStream
        Me.OutputStream = OutputStream

        Thread = New System.Threading.Thread(New System.Threading.ThreadStart(AddressOf Main))

        Thread.Start()
    End Sub

    Private Sub Main()
        Const nSize As Integer = 64 * 1024
        Dim buffer(nSize) As Byte
        Dim i As Integer

        Dim nReadBytes As Integer

        While (True)
            nReadBytes = EncryptedStream.Read(buffer, 0, nSize)

            ' Simple decryption
            For i = 0 To nSize
                buffer(i) = buffer(i) Xor &H35
            Next

            If 0 = nReadBytes Then Exit While

            Try
                OutputStream.Write(buffer, 0, nReadBytes)
            Catch e As System.IO.IOException
                ' Loading is interrupted
                Exit While
            End Try

        End While

        EncryptedStream.Close()
        OutputStream.Close()
    End Sub
End Class
