Public Class MainForm
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents f_in_box__control1 As f_in_box__lib.f_in_box__control
    Friend WithEvents ButtonPlayFlashFileFromURL As System.Windows.Forms.Button
    Friend WithEvents openFileDialogFlashFile As System.Windows.Forms.OpenFileDialog
    Friend WithEvents labelSoundVolume As System.Windows.Forms.Label
    Friend WithEvents trackBarSoundVolume As System.Windows.Forms.TrackBar
    Friend WithEvents ButtonPlayFlashFileFromFile As System.Windows.Forms.Button
    Friend WithEvents CheckBoxEnableSounds As System.Windows.Forms.CheckBox
    Friend WithEvents CheckBoxEnableStandardContextMenu As System.Windows.Forms.CheckBox
    Friend WithEvents ButtonOrder As System.Windows.Forms.Button
    Friend WithEvents ButtonAbout As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.f_in_box__control1 = New f_in_box__lib.f_in_box__control
        Me.ButtonPlayFlashFileFromURL = New System.Windows.Forms.Button
        Me.openFileDialogFlashFile = New System.Windows.Forms.OpenFileDialog
        Me.labelSoundVolume = New System.Windows.Forms.Label
        Me.trackBarSoundVolume = New System.Windows.Forms.TrackBar
        Me.ButtonPlayFlashFileFromFile = New System.Windows.Forms.Button
        Me.CheckBoxEnableSounds = New System.Windows.Forms.CheckBox
        Me.CheckBoxEnableStandardContextMenu = New System.Windows.Forms.CheckBox
        Me.ButtonOrder = New System.Windows.Forms.Button
        Me.ButtonAbout = New System.Windows.Forms.Button
        CType(Me.trackBarSoundVolume, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'f_in_box__control1
        '
        Me.f_in_box__control1.FlashProperty_AlignMode = 0
        Me.f_in_box__control1.FlashProperty_AllowScriptAccess = ""
        Me.f_in_box__control1.FlashProperty_BackgroundColor = -1
        Me.f_in_box__control1.FlashProperty_Base = ""
        Me.f_in_box__control1.FlashProperty_BGColor = ""
        Me.f_in_box__control1.FlashProperty_DeviceFont = False
        Me.f_in_box__control1.FlashProperty_EmbedMovie = False
        Me.f_in_box__control1.FlashProperty_FlashVars = ""
        Me.f_in_box__control1.FlashProperty_FrameNum = -1
        Me.f_in_box__control1.FlashProperty_Loop = True
        Me.f_in_box__control1.FlashProperty_Menu = True
        Me.f_in_box__control1.FlashProperty_Movie = ""
        Me.f_in_box__control1.FlashProperty_MovieData = ""
        Me.f_in_box__control1.FlashProperty_Playing = True
        Me.f_in_box__control1.FlashProperty_Quality = 1
        Me.f_in_box__control1.FlashProperty_Quality2 = "High"
        Me.f_in_box__control1.FlashProperty_SAlign = ""
        Me.f_in_box__control1.FlashProperty_Scale = "ShowAll"
        Me.f_in_box__control1.FlashProperty_ScaleMode = 0
        Me.f_in_box__control1.FlashProperty_Stacking = ""
        Me.f_in_box__control1.FlashProperty_SWRemote = ""
        Me.f_in_box__control1.FlashProperty_WMode = "Window"
        Me.f_in_box__control1.Location = New System.Drawing.Point(8, 8)
        Me.f_in_box__control1.Name = "f_in_box__control1"
        Me.f_in_box__control1.Size = New System.Drawing.Size(616, 368)
        Me.f_in_box__control1.StandardMenu = False
        Me.f_in_box__control1.TabIndex = 27
        Me.f_in_box__control1.Text = "f_in_box__control1"
        '
        'ButtonPlayFlashFileFromURL
        '
        Me.ButtonPlayFlashFileFromURL.Location = New System.Drawing.Point(8, 452)
        Me.ButtonPlayFlashFileFromURL.Name = "ButtonPlayFlashFileFromURL"
        Me.ButtonPlayFlashFileFromURL.Size = New System.Drawing.Size(152, 23)
        Me.ButtonPlayFlashFileFromURL.TabIndex = 26
        Me.ButtonPlayFlashFileFromURL.Text = "Play SWF / FLV from URL..."
        '
        'openFileDialogFlashFile
        '
        Me.openFileDialogFlashFile.Filter = "Flash files (*.swf;*.flv)|*.swf;*.flv|Flash movies (*.swf)|*.swf|Flash video file" & _
        "s (*.flv)|*.flv|All files (*.*)|*.*||"
        Me.openFileDialogFlashFile.RestoreDirectory = True
        Me.openFileDialogFlashFile.ShowReadOnly = True
        '
        'labelSoundVolume
        '
        Me.labelSoundVolume.Location = New System.Drawing.Point(576, 388)
        Me.labelSoundVolume.Name = "labelSoundVolume"
        Me.labelSoundVolume.Size = New System.Drawing.Size(48, 23)
        Me.labelSoundVolume.TabIndex = 25
        Me.labelSoundVolume.Text = "label1"
        '
        'trackBarSoundVolume
        '
        Me.trackBarSoundVolume.Location = New System.Drawing.Point(288, 380)
        Me.trackBarSoundVolume.Name = "trackBarSoundVolume"
        Me.trackBarSoundVolume.Size = New System.Drawing.Size(280, 45)
        Me.trackBarSoundVolume.TabIndex = 24
        '
        'ButtonPlayFlashFileFromFile
        '
        Me.ButtonPlayFlashFileFromFile.Location = New System.Drawing.Point(8, 420)
        Me.ButtonPlayFlashFileFromFile.Name = "ButtonPlayFlashFileFromFile"
        Me.ButtonPlayFlashFileFromFile.Size = New System.Drawing.Size(152, 23)
        Me.ButtonPlayFlashFileFromFile.TabIndex = 21
        Me.ButtonPlayFlashFileFromFile.Text = "Play SWF / FLV from file..."
        '
        'CheckBoxEnableSounds
        '
        Me.CheckBoxEnableSounds.Location = New System.Drawing.Point(184, 380)
        Me.CheckBoxEnableSounds.Name = "CheckBoxEnableSounds"
        Me.CheckBoxEnableSounds.TabIndex = 20
        Me.CheckBoxEnableSounds.Text = "Enable sounds"
        '
        'CheckBoxEnableStandardContextMenu
        '
        Me.CheckBoxEnableStandardContextMenu.Location = New System.Drawing.Point(8, 380)
        Me.CheckBoxEnableStandardContextMenu.Name = "CheckBoxEnableStandardContextMenu"
        Me.CheckBoxEnableStandardContextMenu.Size = New System.Drawing.Size(176, 24)
        Me.CheckBoxEnableStandardContextMenu.TabIndex = 19
        Me.CheckBoxEnableStandardContextMenu.Text = "Enable standard context menu"
        '
        'ButtonOrder
        '
        Me.ButtonOrder.Location = New System.Drawing.Point(488, 452)
        Me.ButtonOrder.Name = "ButtonOrder"
        Me.ButtonOrder.Size = New System.Drawing.Size(136, 23)
        Me.ButtonOrder.TabIndex = 23
        Me.ButtonOrder.Text = "Buy license"
        '
        'ButtonAbout
        '
        Me.ButtonAbout.Location = New System.Drawing.Point(344, 452)
        Me.ButtonAbout.Name = "ButtonAbout"
        Me.ButtonAbout.Size = New System.Drawing.Size(136, 23)
        Me.ButtonAbout.TabIndex = 22
        Me.ButtonAbout.Text = "More about F-IN-BOX"
        '
        'MainForm
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(632, 486)
        Me.Controls.Add(Me.ButtonPlayFlashFileFromURL)
        Me.Controls.Add(Me.labelSoundVolume)
        Me.Controls.Add(Me.trackBarSoundVolume)
        Me.Controls.Add(Me.ButtonPlayFlashFileFromFile)
        Me.Controls.Add(Me.CheckBoxEnableSounds)
        Me.Controls.Add(Me.CheckBoxEnableStandardContextMenu)
        Me.Controls.Add(Me.ButtonOrder)
        Me.Controls.Add(Me.ButtonAbout)
        Me.Controls.Add(Me.f_in_box__control1)
        Me.MaximizeBox = False
        Me.Name = "MainForm"
        Me.Text = "Sample 1 - SWF Player and FLV Player"
        CType(Me.trackBarSoundVolume, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub MainForm_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        openFileDialogFlashFile.InitialDirectory = System.IO.Path.GetDirectoryName(Application.ExecutablePath())
        CheckBoxEnableStandardContextMenu.Checked = f_in_box__control1.StandardMenu
        CheckBoxEnableSounds.Checked = f_in_box__control1.AxCode.SoundEnabled

        If f_in_box__control1.AxCode.SoundEnabled Then
            labelSoundVolume.Text = (f_in_box__control1.AxCode.SoundVolume * 100 \ f_in_box__lib.AxCode.MaxSoundVolume).ToString() + " %"
        Else : labelSoundVolume.Text = "Disabled"
        End If

        trackBarSoundVolume.Enabled = f_in_box__control1.AxCode.SoundEnabled

        trackBarSoundVolume.Minimum = 0
        trackBarSoundVolume.Maximum = 100
        trackBarSoundVolume.TickFrequency = 10
        trackBarSoundVolume.Value = Convert.ToInt32(f_in_box__control1.AxCode.SoundVolume) * 100 \ Convert.ToInt32(f_in_box__lib.AxCode.MaxSoundVolume)

        f_in_box__control1.PutMovieFromStream(Me.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.movie.swf"))
        f_in_box__control1.FlashMethod_Play()
    End Sub

    Private Sub ButtonAbout_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/")
    End Sub

    Private Sub ButtonOrder_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/order.html")
    End Sub

    Private Sub ButtonPlayFlashFileFromFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPlayFlashFileFromFile.Click
        If openFileDialogFlashFile.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
            If openFileDialogFlashFile.FileName.EndsWith(".swf") Then
                f_in_box__control1.FlashProperty_Movie = openFileDialogFlashFile.FileName
                f_in_box__control1.FlashMethod_Play()
            Else
                ' First way -- provide FLV content using ContentProvider
                ' Additionally, see Sample2_SWF_FLV_Embedding
                ' This way is useful when you provide FLV from memory, stream, database and so on
                ' When you should play FLV from URL / local file, use the Second way (see below)
                ' Dim ContentProvider As New ContentProvider(f_in_box__control1.AxCode, openFileDialogFlashFile.FileName)
                ' f_in_box__control1.PutMovieFromStream(Me.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.FLVPlayer.swf"))
                ' f_in_box__control1.FlashMethod_Play()

                ' Second way -- just provide URL for Flash
                f_in_box__control1.FlashProperty_FlashVars = "FLVPath=" + System.Web.HttpUtility.HtmlEncode("file://" + openFileDialogFlashFile.FileName)
                f_in_box__control1.PutMovieFromStream(Me.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.FLVPlayer.swf"))
                f_in_box__control1.FlashMethod_Play()
            End If
        End If
    End Sub

    Private Sub ButtonPlayFlashFileFromURL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonPlayFlashFileFromURL.Click
        Dim FormURL As New FormURL

        If System.Windows.Forms.DialogResult.OK = FormURL.ShowDialog() Then
            If FormURL.IsFLV Then
                ' First way -- provide FLV content using ContentProvider
                ' Additionally, see Sample2_SWF_FLV_Embedding
                ' This way is useful when you provide FLV from memory, stream, database and so on
                ' When you should play FLV from URL / local file, use the Second way (see below)
                ' Dim ContentProvider As New ContentProviderFromURL(f_in_box__control1.AxCode, FormURL.URL)
                ' f_in_box__control1.PutMovieFromStream(Me.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.FLVPlayer.swf"))
                ' f_in_box__control1.FlashMethod_Play()

                ' Second way -- just provide URL for Flash
                f_in_box__control1.FlashProperty_FlashVars = "FLVPath=" + System.Web.HttpUtility.HtmlEncode(FormURL.URL)
                f_in_box__control1.PutMovieFromStream(Me.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.FLVPlayer.swf"))
            Else
                f_in_box__control1.FlashProperty_Movie = FormURL.URL
            End If

            f_in_box__control1.FlashMethod_Play()
        End If
    End Sub

    Private Sub CheckBoxEnableStandardContextMenu_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBoxEnableStandardContextMenu.CheckedChanged
        f_in_box__control1.StandardMenu = CheckBoxEnableStandardContextMenu.Checked
    End Sub

    Private Sub CheckBoxEnableSounds_CheckStateChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles CheckBoxEnableSounds.CheckedChanged
        f_in_box__control1.AxCode.SoundEnabled = CheckBoxEnableSounds.Checked

        trackBarSoundVolume.Enabled = f_in_box__control1.AxCode.SoundEnabled

        If f_in_box__control1.AxCode.SoundEnabled Then
            labelSoundVolume.Text = (f_in_box__control1.AxCode.SoundVolume * 100 \ f_in_box__lib.AxCode.MaxSoundVolume).ToString() + " %"
        Else : labelSoundVolume.Text = "Disabled"
        End If
    End Sub

    Private Sub trackBarSoundVolume_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles trackBarSoundVolume.Scroll
        f_in_box__control1.AxCode.SoundVolume = trackBarSoundVolume.Value * f_in_box__lib.AxCode.MaxSoundVolume / 100

        labelSoundVolume.Text = (f_in_box__control1.AxCode.SoundVolume * 100 \ f_in_box__lib.AxCode.MaxSoundVolume).ToString() + " %"
    End Sub
End Class

Class FromStreamToStreamWriter
    Private FromStream As System.IO.Stream
    Private ToStream As System.IO.Stream
    Private Thread As System.Threading.Thread

    Public Sub New(ByVal FromStream As System.IO.Stream, ByVal ToStream As System.IO.Stream)
        Me.FromStream = FromStream
        Me.ToStream = ToStream

        Thread = New System.Threading.Thread(New System.Threading.ThreadStart(AddressOf Main))

        Thread.Start()
    End Sub

    Private Sub Main()
        Const nSize As Integer = 64 * 1024
        Dim buffer(nSize) As Byte

        Dim nReadBytes As Integer

        While (True)
            nReadBytes = FromStream.Read(buffer, 0, nSize)

            If 0 = nReadBytes Then Exit While

            Try
                ToStream.Write(buffer, 0, nReadBytes)
            Catch e As System.IO.IOException
                ' Loading is interrupted
                Exit While
            End Try

        End While

        FromStream.Close()
        ToStream.Close()
    End Sub
End Class

Class ContentProvider
    Private Path As String
    Private AxCode As f_in_box__lib.AxCode

    Sub New(ByVal AxCode As f_in_box__lib.AxCode, ByVal Path As String)
        Me.Path = Path
        Me.AxCode = AxCode

        AddHandler AxCode.OnLoadExternalResourceByFullPath, AddressOf OnLoadExternalResourceByFullPath
    End Sub

    Private Sub OnLoadExternalResourceByFullPath(ByVal sender As Object, ByVal URL As String, ByVal Stream As System.IO.Stream, ByRef Handled As Boolean)
        If URL = "http://FLV/FlashVideo.flv" Then
            Dim FromStream As System.IO.Stream = System.IO.File.OpenRead(Path)

            Dim writer As FromStreamToStreamWriter = New FromStreamToStreamWriter(FromStream, Stream)

            Handled = True

            RemoveHandler AxCode.OnLoadExternalResourceByFullPath, AddressOf OnLoadExternalResourceByFullPath
        End If
    End Sub
End Class

Class ContentProviderFromURL
    Private URL As String
    Private AxCode As f_in_box__lib.AxCode
    Private ToStream As System.IO.Stream

    Sub New(ByVal AxCode As f_in_box__lib.AxCode, ByVal URL As String)
        Me.URL = URL
        Me.AxCode = AxCode

        AddHandler AxCode.OnLoadExternalResourceByFullPath, AddressOf OnLoadExternalResourceByFullPath
    End Sub

    Private Sub Main()
        Dim FromStream As System.IO.Stream = Nothing

        Try
            Dim request As System.Net.HttpWebRequest

            request = System.Net.HttpWebRequest.Create(URL)

            FromStream = request.GetResponse().GetResponseStream()

            Const nSize As Integer = 64 * 1024
            Dim buffer(nSize) As Byte

            Dim nReadBytes As Integer

            While (True)
                nReadBytes = FromStream.Read(buffer, 0, nSize)

                If 0 = nReadBytes Then Exit While

                Try
                    ToStream.Write(buffer, 0, nReadBytes)
                Catch e As System.IO.IOException
                    ' Loading is interrupted
                    Exit While
                End Try

            End While

        Catch e As System.Exception
            MessageBox.Show(e.ToString())
        End Try

        If Not FromStream Is Nothing Then FromStream.Close()

        ToStream.Close()
    End Sub

    Private Sub OnLoadExternalResourceByFullPath(ByVal sender As Object, ByVal URL As String, ByVal Stream As System.IO.Stream, ByRef Handled As Boolean)
        If URL = "http://FLV/FlashVideo.flv" Then

            ToStream = Stream

            Dim Thread As System.Threading.Thread = New System.Threading.Thread(New System.Threading.ThreadStart(AddressOf Main))

            Thread.Start()

            Handled = True

            RemoveHandler AxCode.OnLoadExternalResourceByFullPath, AddressOf OnLoadExternalResourceByFullPath
        End If
    End Sub
End Class
