Imports Microsoft.DirectX
Imports Microsoft.DirectX.Direct3D
Imports System.Runtime.InteropServices

Public Class Form1
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents F_in_box__control1 As f_in_box__lib.f_in_box__control
    Friend WithEvents Timer1 As System.Timers.Timer
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.F_in_box__control1 = New f_in_box__lib.f_in_box__control
        Me.Timer1 = New System.Timers.Timer
        CType(Me.Timer1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'F_in_box__control1
        '
        Me.F_in_box__control1.Context = Nothing
        Me.F_in_box__control1.FlashProperty_AlignMode = 0
        Me.F_in_box__control1.FlashProperty_AllowScriptAccess = ""
        Me.F_in_box__control1.FlashProperty_BackgroundColor = -1
        Me.F_in_box__control1.FlashProperty_Base = ""
        Me.F_in_box__control1.FlashProperty_BGColor = ""
        Me.F_in_box__control1.FlashProperty_DeviceFont = False
        Me.F_in_box__control1.FlashProperty_EmbedMovie = False
        Me.F_in_box__control1.FlashProperty_FlashVars = ""
        Me.F_in_box__control1.FlashProperty_FrameNum = -1
        Me.F_in_box__control1.FlashProperty_Loop = True
        Me.F_in_box__control1.FlashProperty_Menu = True
        Me.F_in_box__control1.FlashProperty_Movie = ""
        Me.F_in_box__control1.FlashProperty_MovieData = ""
        Me.F_in_box__control1.FlashProperty_Playing = True
        Me.F_in_box__control1.FlashProperty_Quality = 1
        Me.F_in_box__control1.FlashProperty_Quality2 = "High"
        Me.F_in_box__control1.FlashProperty_SAlign = ""
        Me.F_in_box__control1.FlashProperty_Scale = "ShowAll"
        Me.F_in_box__control1.FlashProperty_ScaleMode = 0
        Me.F_in_box__control1.FlashProperty_Stacking = ""
        Me.F_in_box__control1.FlashProperty_SWRemote = ""
        Me.F_in_box__control1.FlashProperty_WMode = "Window"
        Me.F_in_box__control1.Location = New System.Drawing.Point(120, 72)
        Me.F_in_box__control1.Name = "F_in_box__control1"
        Me.F_in_box__control1.Size = New System.Drawing.Size(120, 80)
        Me.F_in_box__control1.StandardMenu = False
        Me.F_in_box__control1.TabIndex = 0
        Me.F_in_box__control1.Text = "F_in_box__control1"
        Me.F_in_box__control1.TransparentMode = False
        '
        'Timer1
        '
        Me.Timer1.Enabled = True
        Me.Timer1.SynchronizingObject = Me
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(292, 266)
        Me.Controls.Add(Me.F_in_box__control1)
        Me.Name = "Form1"
        Me.Text = "Sample 10 - Flash Texture"
        CType(Me.Timer1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Dim _Device As Device = Nothing
    Const nVertices As Integer = 5
    Dim _VertexBuffer As VertexBuffer = Nothing
    Dim _IndexBuffer As IndexBuffer = Nothing
    Dim vertex(nVertices) As CustomVertex.PositionTextured
    Dim indices() As Short = { _
           4, 0, 3, _
           4, 1, 0, _
           4, 2, 1, _
           4, 3, 2 _
          }
    Dim _Camera As Vector3 = New Vector3(0, 0, -5)
    Dim _At As Vector3 = New Vector3(0, 0, 0)
    Dim _Up As Vector3 = New Vector3(0, 1, 0)
    Dim _FieldOfView As Single = Math.PI / 4
    Dim _Hither As Single = 2.0F
    Dim _Yon As Single = 50.0F
    Dim _Angle As Single = 1.0F
    Dim _DeviceState As Boolean = True
    Dim _DeviceLost As Boolean = False

    Dim _PresentParameters As PresentParameters = New PresentParameters

    Const _Width As Integer = 256
    Const _Height As Integer = 256

    Dim Started As Boolean = False

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        vertex(0) = New CustomVertex.PositionTextured(-1.0F, +1.0F, 0.0F, 0, 1)
        vertex(1) = New CustomVertex.PositionTextured(-1.0F, -1.0F, 0.0F, 0, 0)
        vertex(2) = New CustomVertex.PositionTextured(+1.0F, -1.0F, 0.0F, 1, 0)
        vertex(3) = New CustomVertex.PositionTextured(+1.0F, +1.0F, 0.0F, 1, 1)
        vertex(4) = New CustomVertex.PositionTextured(0.0F, 0.0F, 5.0F / Math.Sqrt(2), 0.5F, 0.5F)

        _PresentParameters.Windowed = True
        _PresentParameters.SwapEffect = SwapEffect.Discard
        _PresentParameters.EnableAutoDepthStencil = True
        _PresentParameters.AutoDepthStencilFormat = DepthFormat.D16

        _Device = New Device(0, DeviceType.Hardware, Me, CreateFlags.SoftwareVertexProcessing, _PresentParameters)

        AddHandler _Device.DeviceReset, AddressOf OnCreateDevice
        AddHandler _Device.DeviceResizing, AddressOf OnDeviceResize

        OnCreateDevice(_Device, Nothing)

        F_in_box__control1.TransparentMode = True
        F_in_box__control1.Width = _Width
        F_in_box__control1.Height = _Height
        F_in_box__control1.PutMovieFromStream(Me.GetType().Assembly.GetManifestResourceStream("Sample10_FlashTexture.movie.swf"))
        F_in_box__control1.FlashMethod_Play()
        F_in_box__control1.Visible = False
        F_in_box__control1.FlashProperty_BackgroundColor = &HFFFF00

        Started = True
    End Sub

    Sub OnCreateDevice(ByVal sender As Object, ByVal e As EventArgs)
        Timer1.Enabled = False

        SetUpCamera()

        _VertexBuffer = _
         New VertexBuffer( _
          GetType(CustomVertex.PositionTextured), _
          nVertices, _
          _Device, _
          Usage.Dynamic Or Usage.WriteOnly, _
          CustomVertex.PositionTextured.Format, _
          Pool.Default)

        _IndexBuffer = _
         New IndexBuffer( _
          GetType(Short), _
          indices.Length, _
          _Device, _
          Usage.WriteOnly, _
          Pool.Default)

        If e Is Nothing Then
            AddHandler _VertexBuffer.Created, AddressOf OnVertexBufferCreate
            AddHandler _IndexBuffer.Created, AddressOf OnIndexBufferCreate

            OnVertexBufferCreate(_VertexBuffer, Nothing)
            OnIndexBufferCreate(_IndexBuffer, Nothing)
        End If
    End Sub

    Sub OnVertexBufferCreate(ByVal sender As Object, ByVal e As EventArgs)
        _VertexBuffer.SetData(vertex, 0, LockFlags.None)
    End Sub

    Sub OnIndexBufferCreate(ByVal sender As Object, ByVal e As EventArgs)
        _IndexBuffer.SetData(indices, 0, LockFlags.None)

        Timer1.Enabled = True
    End Sub

    Sub OnDeviceResize(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs)
        _DeviceState = Not _DeviceState
    End Sub

    Sub SetUpCamera()
        Dim AspectRatio As Single = ClientSize.Width / ClientSize.Height

        _Device.Transform.Projection = _
         Matrix.PerspectiveFovLH(_FieldOfView, AspectRatio, _Hither, _Yon)

        _Device.Transform.View = Matrix.LookAtLH(_Camera, _At, _Up)

        _Device.RenderState.Lighting = False
    End Sub

    Sub AttemptRecovery()
        Try
            _Device.TestCooperativeLevel()
        Catch ex As DeviceLostException
            Exit Try
        Catch ex As DeviceNotResetException
            Try
                _Device.Reset(_PresentParameters)
                _DeviceLost = False
            Catch ex1 As DeviceLostException
            End Try
        End Try
    End Sub

    <DllImport("user32.dll")> Public Shared Function SendMessageA(ByVal hWnd As IntPtr, ByVal uMsg As Integer, ByVal wParam As Integer, ByVal lParam As Integer) As Integer
    End Function

    Const WM_PAINT As Integer = &HF

    Dim _FlashTexture As Texture = Nothing
    Dim _RectToUpdate As System.Drawing.Rectangle

    Private Sub F_in_box__control1_OnUpdateRect(ByVal sender As Object, ByVal RectToUpdate As System.Drawing.Rectangle) Handles F_in_box__control1.OnUpdateRect
        Dim f_in_box__control As f_in_box__lib.f_in_box__control = sender

        _RectToUpdate = RectToUpdate

        SendMessageA(f_in_box__control.Handle, WM_PAINT, 0, 0)
    End Sub

    Private Sub F_in_box__control1_OnFlashPaint(ByVal sender As Object, ByVal pPixelPointer As System.IntPtr) Handles F_in_box__control1.OnFlashPaint
        If Not Started Then
            Exit Sub
        End If

        Dim f_in_box__control As f_in_box__lib.f_in_box__control = sender

        If _FlashTexture Is Nothing Then
            _FlashTexture = New Texture(_Device, _Width, _Height, 1, Usage.None, Format.A8R8G8B8, Pool.Managed)
        End If

        Dim gs As GraphicsStream = _FlashTexture.LockRectangle(0, LockFlags.Discard)

        Dim pixels(_Width * _Height * 4) As Byte

        System.Runtime.InteropServices.Marshal.Copy(pPixelPointer, pixels, 0, _Width * _Height * 4)

        gs.Write(pixels, 0, pixels.Length)

        _FlashTexture.UnlockRectangle(0)
    End Sub

    Private Sub Timer1_Elapsed(ByVal sender As Object, ByVal e As System.Timers.ElapsedEventArgs) Handles Timer1.Elapsed
        If _Device Is Nothing Then
            Exit Sub
        End If

        If _DeviceLost Then
            AttemptRecovery()
        End If

        If _FlashTexture Is Nothing Then
            Exit Sub
        End If

        Try
            _Device.Clear(ClearFlags.Target Or ClearFlags.ZBuffer, Color.Khaki, 1.0F, 0)

            _Device.BeginScene()

            _Device.VertexFormat = CustomVertex.PositionTextured.Format

            _Device.SetTexture(0, _FlashTexture)

            _Device.SetStreamSource(0, _VertexBuffer, 0)
            _Device.Indices = _IndexBuffer

            _Angle = _Angle + 0.05F

            If (_Angle > 360) Then
                _Angle = 1.0F
            End If

            _Device.Transform.World = Matrix.RotationYawPitchRoll(0, -0.75F, _Angle)

            _Device.DrawIndexedPrimitives(PrimitiveType.TriangleList, 0, 0, nVertices, 0, indices.Length / 3)

            _Device.EndScene()

            _Device.Present()
        Catch ex As DeviceLostException
            _DeviceLost = True
        End Try
    End Sub
End Class
