using System;
using System.Windows.Forms;

namespace Sample04_Translucency
{
	/// <summary>
	/// Summary description for MainModule.
	/// </summary>
	public class MainModule
	{
		public static void Main()
		{
			// Check transparent mode
			if (!f_in_box__lib.Global.IsTransparentModeAvailable)
			{
				System.Windows.Forms.MessageBox.Show("Transparent mode is not available");
				return;
			}

			// MyTranslucencyForm is inherited from f_in_box__lib.f_in_box__form; see MyTranslucencyForm.vb
			// Creating translucency form 
			MyTranslucencyForm FlashPlayerForm = new MyTranslucencyForm();

			// Loading movie from stream
			System.IO.Stream MovieStream = System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Sample04_Translucency.Embedded_Movies.movie.swf");
			FlashPlayerForm.PutMovieFromStream(MovieStream);

			// Positions
			FlashPlayerForm.Width = 400;
			FlashPlayerForm.Height = 400;
			FlashPlayerForm.Left = System.Windows.Forms.Screen.PrimaryScreen.WorkingArea.Width / 2 - FlashPlayerForm.Width / 2;
			FlashPlayerForm.Top = System.Windows.Forms.Screen.PrimaryScreen.WorkingArea.Height / 2 - FlashPlayerForm.Height / 2;

			// Play and...
			FlashPlayerForm.FlashMethod_Play();
			// ...show
			FlashPlayerForm.Show();

			Application.Run(FlashPlayerForm);
		}
	}
}
