using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Sample03_StandalonePlayer
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.OpenFileDialog OpenSWFFileDialog;
		internal System.Windows.Forms.Button PlaySWFFromFileButton;
		internal System.Windows.Forms.CheckBox SoundsCheckBox;
		internal System.Windows.Forms.CheckBox StandardMenuCheckBox;
		internal System.Windows.Forms.Button MoreAboutComponentButton;
		internal System.Windows.Forms.Button OrderButton;
		private System.Windows.Forms.PictureBox pictureBox1;

		private f_in_box__lib.f_in_box__control f_in_box__control1;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.OpenSWFFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.PlaySWFFromFileButton = new System.Windows.Forms.Button();
			this.SoundsCheckBox = new System.Windows.Forms.CheckBox();
			this.StandardMenuCheckBox = new System.Windows.Forms.CheckBox();
			this.MoreAboutComponentButton = new System.Windows.Forms.Button();
			this.OrderButton = new System.Windows.Forms.Button();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.SuspendLayout();
			// 
			// OpenSWFFileDialog
			// 
			this.OpenSWFFileDialog.Filter = "Flash Movies (*.swf)|*.swf|All Files (*.*)|*.*";
			// 
			// PlaySWFFromFileButton
			// 
			this.PlaySWFFromFileButton.Location = new System.Drawing.Point(8, 408);
			this.PlaySWFFromFileButton.Name = "PlaySWFFromFileButton";
			this.PlaySWFFromFileButton.Size = new System.Drawing.Size(128, 24);
			this.PlaySWFFromFileButton.TabIndex = 9;
			this.PlaySWFFromFileButton.Text = "Play SWF from file...";
			this.PlaySWFFromFileButton.Click += new System.EventHandler(this.PlaySWFFromFileButton_Click);
			// 
			// SoundsCheckBox
			// 
			this.SoundsCheckBox.Location = new System.Drawing.Point(232, 376);
			this.SoundsCheckBox.Name = "SoundsCheckBox";
			this.SoundsCheckBox.TabIndex = 6;
			this.SoundsCheckBox.Text = "Enable sounds";
			this.SoundsCheckBox.CheckedChanged += new System.EventHandler(this.SoundsCheckBox_CheckedChanged);
			// 
			// StandardMenuCheckBox
			// 
			this.StandardMenuCheckBox.Location = new System.Drawing.Point(8, 376);
			this.StandardMenuCheckBox.Name = "StandardMenuCheckBox";
			this.StandardMenuCheckBox.Size = new System.Drawing.Size(216, 24);
			this.StandardMenuCheckBox.TabIndex = 5;
			this.StandardMenuCheckBox.Text = "Enable standard flash context menu";
			this.StandardMenuCheckBox.CheckedChanged += new System.EventHandler(this.StandardMenuCheckBox_CheckedChanged);
			// 
			// MoreAboutComponentButton
			// 
			this.MoreAboutComponentButton.Location = new System.Drawing.Point(272, 408);
			this.MoreAboutComponentButton.Name = "MoreAboutComponentButton";
			this.MoreAboutComponentButton.Size = new System.Drawing.Size(176, 24);
			this.MoreAboutComponentButton.TabIndex = 8;
			this.MoreAboutComponentButton.Text = "More about F-IN-BOX";
			this.MoreAboutComponentButton.Click += new System.EventHandler(this.MoreAboutComponentButton_Click);
			// 
			// OrderButton
			// 
			this.OrderButton.Location = new System.Drawing.Point(456, 408);
			this.OrderButton.Name = "OrderButton";
			this.OrderButton.Size = new System.Drawing.Size(168, 24);
			this.OrderButton.TabIndex = 7;
			this.OrderButton.Text = "Buy license";
			this.OrderButton.Click += new System.EventHandler(this.OrderButton_Click);
			// 
			// pictureBox1
			// 
			this.pictureBox1.Location = new System.Drawing.Point(8, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(616, 360);
			this.pictureBox1.TabIndex = 10;
			this.pictureBox1.TabStop = false;
			this.pictureBox1.Visible = false;
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(632, 446);
			this.Controls.Add(this.pictureBox1);
			this.Controls.Add(this.SoundsCheckBox);
			this.Controls.Add(this.StandardMenuCheckBox);
			this.Controls.Add(this.MoreAboutComponentButton);
			this.Controls.Add(this.OrderButton);
			this.Controls.Add(this.PlaySWFFromFileButton);
			this.MaximizeBox = false;
			this.Name = "MainForm";
			this.Text = "Sample 3 - Standalone Flash Player (how to embed flash.ocx into an application)";
			this.Load += new System.EventHandler(this.MainForm_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			// Loads flash.ocx from resource
			System.IO.Stream StreamWithFlashOCXCode;
            
            if (IntPtr.Size == 8)
                // 64 bit Windows
            {
                // Don't forget to add Flash64_14_0_0_176.ocx to the project
                StreamWithFlashOCXCode = GetType().Assembly.GetManifestResourceStream("Sample03_StandalonePlayer.flash_ocx.Flash64_14_0_0_176.ocx");
            }
            else
                // 32 bit Windows
            {
                StreamWithFlashOCXCode = GetType().Assembly.GetManifestResourceStream("Sample03_StandalonePlayer.flash_ocx.flash.ocx");
            }

			if (StreamWithFlashOCXCode == null)
			{
				System.Windows.Forms.MessageBox.Show("Resource 'Flash.ocx' not found");
				return;
			}

			f_in_box__lib.AxCode code = new f_in_box__lib.AxCode(StreamWithFlashOCXCode);

			f_in_box__control1 = new f_in_box__lib.f_in_box__control(code);

			Controls.Add(f_in_box__control1);

			f_in_box__control1.Location = pictureBox1.Location;
			f_in_box__control1.Size = pictureBox1.Size;

			f_in_box__control1.Visible = true;

			OpenSWFFileDialog.InitialDirectory = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
			StandardMenuCheckBox.Checked = f_in_box__control1.StandardMenu;
			SoundsCheckBox.Checked = f_in_box__control1.AxCode.SoundEnabled;

			f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample03_StandalonePlayer.Embedded_Movies.movie.swf"));
			f_in_box__control1.FlashMethod_Play();
		}

		private void PlaySWFFromFileButton_Click(object sender, System.EventArgs e)
		{
			if (OpenSWFFileDialog.ShowDialog() == DialogResult.OK)
	            f_in_box__control1.FlashProperty_Movie = OpenSWFFileDialog.FileName;
		}

		private void StandardMenuCheckBox_CheckedChanged(object sender, System.EventArgs e)
		{
	        f_in_box__control1.StandardMenu = StandardMenuCheckBox.Checked;
		}

		private void SoundsCheckBox_CheckedChanged(object sender, System.EventArgs e)
		{
	        f_in_box__control1.AxCode.SoundEnabled = SoundsCheckBox.Checked;
		}

		private void MoreAboutComponentButton_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/");
		}

		private void OrderButton_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/order.html");
		}
	}
}
