using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace Sample04_Translucency
{
	/// <summary>
	/// Summary description for MyTranslucencyForm.
	/// </summary>
	public class MyTranslucencyForm : f_in_box__lib.f_in_box__form
	{
		private int m_nX = 0, m_nY = 0;
		private int m_nLeft = 0, m_nTop = 0;

		private ContextMenu m_ContextMenu = new ContextMenu();

		public MyTranslucencyForm()
		{
			//
			// TODO: Add constructor logic here
			//

			Visible = true;

			Text = "You can create cool semitransparent forms with F-IN-BOX!";

			MenuItem MenuItemMinimize = new MenuItem();
			MenuItemMinimize.Text = "Minimize";
			MenuItemMinimize.Click += new System.EventHandler(this.OnMenuMinimize);
			m_ContextMenu.MenuItems.Add(MenuItemMinimize);

			MenuItem MenuItemClose = new MenuItem();
			MenuItemClose.Text = "Close";
			MenuItemClose.Click += new System.EventHandler(this.OnMenuClose);
			m_ContextMenu.MenuItems.Add(MenuItemClose);

			// Add separator
			m_ContextMenu.MenuItems.Add("-");

			MenuItem MenuItemAbout = new MenuItem();
			MenuItemAbout.Text = "More about F-IN-BOX .NET Edition";
			MenuItemAbout.Click += new System.EventHandler(this.OnMenuAbout);
			m_ContextMenu.MenuItems.Add(MenuItemAbout);

			MenuItem MenuItemOrder = new MenuItem();
			MenuItemOrder.Text = "Buy license";
			MenuItemOrder.Click += new System.EventHandler(this.OnMenuOrder);
			m_ContextMenu.MenuItems.Add(MenuItemOrder);

			ContextMenu = m_ContextMenu;

			InitializeComponent();
		}

		protected override void OnMouseDown(MouseEventArgs e)
		{
			m_nX = Left + e.X;
			m_nY = Top + e.Y;

			m_nLeft = Left;
			m_nTop = Top;

			Capture = true;

			base.OnMouseDown(e);
		}

		protected override void OnMouseMove(MouseEventArgs e)
		{
			if (Capture)
			{
				Left = m_nLeft + (Left + e.X - m_nX);
				Top = m_nTop + (Top + e.Y - m_nY);
			}

			base.OnMouseMove(e);
		}

		protected override void OnMouseUp(MouseEventArgs e)
		{
			Capture = false;

			base.OnMouseUp(e);
		}

		private void OnMenuMinimize(Object Sender, System.EventArgs e)
		{
			WindowState = FormWindowState.Minimized;
		}

		private void OnMenuClose(Object Sender, System.EventArgs e)
		{
			Close();
		}

		private void OnMenuAbout(Object Sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/");
		}

		private void OnMenuOrder(Object Sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/order.html");
		}

		private void InitializeComponent()
		{
			// 
			// MyTranslucencyForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(300, 300);
			this.Name = "MyTranslucencyForm";

		}
	}
}
