using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Sample01_SWF_And_FLV_Player
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button ButtonOrder;
		internal System.Windows.Forms.Button ButtonAbout;
		internal System.Windows.Forms.CheckBox CheckBoxEnableSounds;
		internal System.Windows.Forms.CheckBox CheckBoxEnableStandardContextMenu;
		private System.Windows.Forms.TrackBar trackBarSoundVolume;
		private System.Windows.Forms.Label labelSoundVolume;
		internal System.Windows.Forms.OpenFileDialog openFileDialogFlashFile;
		internal System.Windows.Forms.Button ButtonPlayFlashFileFromFile;
		internal System.Windows.Forms.Button ButtonPlayFlashFileFromURL;
		private f_in_box__lib.f_in_box__control f_in_box__control1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.ButtonOrder = new System.Windows.Forms.Button();
			this.ButtonAbout = new System.Windows.Forms.Button();
			this.ButtonPlayFlashFileFromFile = new System.Windows.Forms.Button();
			this.CheckBoxEnableSounds = new System.Windows.Forms.CheckBox();
			this.CheckBoxEnableStandardContextMenu = new System.Windows.Forms.CheckBox();
			this.trackBarSoundVolume = new System.Windows.Forms.TrackBar();
			this.labelSoundVolume = new System.Windows.Forms.Label();
			this.openFileDialogFlashFile = new System.Windows.Forms.OpenFileDialog();
			this.ButtonPlayFlashFileFromURL = new System.Windows.Forms.Button();
			this.f_in_box__control1 = new f_in_box__lib.f_in_box__control();
			((System.ComponentModel.ISupportInitialize)(this.trackBarSoundVolume)).BeginInit();
			this.SuspendLayout();
			// 
			// ButtonOrder
			// 
			this.ButtonOrder.Location = new System.Drawing.Point(488, 448);
			this.ButtonOrder.Name = "ButtonOrder";
			this.ButtonOrder.Size = new System.Drawing.Size(136, 23);
			this.ButtonOrder.TabIndex = 13;
			this.ButtonOrder.Text = "Buy license";
			this.ButtonOrder.Click += new System.EventHandler(this.ButtonOrder_Click);
			// 
			// ButtonAbout
			// 
			this.ButtonAbout.Location = new System.Drawing.Point(344, 448);
			this.ButtonAbout.Name = "ButtonAbout";
			this.ButtonAbout.Size = new System.Drawing.Size(136, 23);
			this.ButtonAbout.TabIndex = 12;
			this.ButtonAbout.Text = "More about F-IN-BOX";
			this.ButtonAbout.Click += new System.EventHandler(this.ButtonAbout_Click);
			// 
			// ButtonPlayFlashFileFromFile
			// 
			this.ButtonPlayFlashFileFromFile.Location = new System.Drawing.Point(8, 416);
			this.ButtonPlayFlashFileFromFile.Name = "ButtonPlayFlashFileFromFile";
			this.ButtonPlayFlashFileFromFile.Size = new System.Drawing.Size(152, 23);
			this.ButtonPlayFlashFileFromFile.TabIndex = 10;
			this.ButtonPlayFlashFileFromFile.Text = "Play SWF / FLV from file...";
			this.ButtonPlayFlashFileFromFile.Click += new System.EventHandler(this.ButtonPlayFlashFileFromFile_Click);
			// 
			// CheckBoxEnableSounds
			// 
			this.CheckBoxEnableSounds.Location = new System.Drawing.Point(184, 376);
			this.CheckBoxEnableSounds.Name = "CheckBoxEnableSounds";
			this.CheckBoxEnableSounds.TabIndex = 9;
			this.CheckBoxEnableSounds.Text = "Enable sounds";
			this.CheckBoxEnableSounds.CheckedChanged += new System.EventHandler(this.CheckBoxEnableSounds_CheckedChanged);
			// 
			// CheckBoxEnableStandardContextMenu
			// 
			this.CheckBoxEnableStandardContextMenu.Location = new System.Drawing.Point(8, 376);
			this.CheckBoxEnableStandardContextMenu.Name = "CheckBoxEnableStandardContextMenu";
			this.CheckBoxEnableStandardContextMenu.Size = new System.Drawing.Size(176, 24);
			this.CheckBoxEnableStandardContextMenu.TabIndex = 8;
			this.CheckBoxEnableStandardContextMenu.Text = "Enable standard context menu";
			this.CheckBoxEnableStandardContextMenu.CheckedChanged += new System.EventHandler(this.CheckBoxEnableStandardContextMenu_CheckedChanged);
			// 
			// trackBarSoundVolume
			// 
			this.trackBarSoundVolume.Location = new System.Drawing.Point(288, 376);
			this.trackBarSoundVolume.Name = "trackBarSoundVolume";
			this.trackBarSoundVolume.Size = new System.Drawing.Size(280, 45);
			this.trackBarSoundVolume.TabIndex = 15;
			this.trackBarSoundVolume.Scroll += new System.EventHandler(this.trackBarSoundVolume_Scroll);
			// 
			// labelSoundVolume
			// 
			this.labelSoundVolume.Location = new System.Drawing.Point(576, 384);
			this.labelSoundVolume.Name = "labelSoundVolume";
			this.labelSoundVolume.Size = new System.Drawing.Size(48, 23);
			this.labelSoundVolume.TabIndex = 16;
			this.labelSoundVolume.Text = "label1";
			// 
			// openFileDialogFlashFile
			// 
			this.openFileDialogFlashFile.Filter = "Flash files (*.swf;*.flv)|*.swf;*.flv|Flash movies (*.swf)|*.swf|Flash video file" +
				"s (*.flv)|*.flv|All files (*.*)|*.*||";
			this.openFileDialogFlashFile.RestoreDirectory = true;
			this.openFileDialogFlashFile.ShowReadOnly = true;
			// 
			// ButtonPlayFlashFileFromURL
			// 
			this.ButtonPlayFlashFileFromURL.Location = new System.Drawing.Point(8, 448);
			this.ButtonPlayFlashFileFromURL.Name = "ButtonPlayFlashFileFromURL";
			this.ButtonPlayFlashFileFromURL.Size = new System.Drawing.Size(152, 23);
			this.ButtonPlayFlashFileFromURL.TabIndex = 17;
			this.ButtonPlayFlashFileFromURL.Text = "Play SWF / FLV from URL...";
			this.ButtonPlayFlashFileFromURL.Click += new System.EventHandler(this.ButtonPlayFlashFileFromURL_Click);
			// 
			// f_in_box__control1
			// 
			this.f_in_box__control1.FlashProperty_AlignMode = 0;
			this.f_in_box__control1.FlashProperty_AllowScriptAccess = "";
			this.f_in_box__control1.FlashProperty_BackgroundColor = -1;
			this.f_in_box__control1.FlashProperty_Base = "";
			this.f_in_box__control1.FlashProperty_BGColor = "";
			this.f_in_box__control1.FlashProperty_DeviceFont = false;
			this.f_in_box__control1.FlashProperty_EmbedMovie = false;
			this.f_in_box__control1.FlashProperty_FlashVars = "";
			this.f_in_box__control1.FlashProperty_FrameNum = -1;
			this.f_in_box__control1.FlashProperty_Loop = true;
			this.f_in_box__control1.FlashProperty_Menu = true;
			this.f_in_box__control1.FlashProperty_Movie = "";
			this.f_in_box__control1.FlashProperty_MovieData = "";
			this.f_in_box__control1.FlashProperty_Playing = true;
			this.f_in_box__control1.FlashProperty_Quality = 1;
			this.f_in_box__control1.FlashProperty_Quality2 = "High";
			this.f_in_box__control1.FlashProperty_SAlign = "";
			this.f_in_box__control1.FlashProperty_Scale = "ShowAll";
			this.f_in_box__control1.FlashProperty_ScaleMode = 0;
			this.f_in_box__control1.FlashProperty_Stacking = "";
			this.f_in_box__control1.FlashProperty_SWRemote = "";
			this.f_in_box__control1.FlashProperty_WMode = "Window";
			this.f_in_box__control1.Location = new System.Drawing.Point(8, 8);
			this.f_in_box__control1.Name = "f_in_box__control1";
			this.f_in_box__control1.Size = new System.Drawing.Size(616, 360);
			this.f_in_box__control1.StandardMenu = false;
			this.f_in_box__control1.TabIndex = 18;
			this.f_in_box__control1.Text = "f_in_box__control1";
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(632, 486);
			this.Controls.Add(this.f_in_box__control1);
			this.Controls.Add(this.ButtonPlayFlashFileFromURL);
			this.Controls.Add(this.labelSoundVolume);
			this.Controls.Add(this.trackBarSoundVolume);
			this.Controls.Add(this.ButtonPlayFlashFileFromFile);
			this.Controls.Add(this.CheckBoxEnableSounds);
			this.Controls.Add(this.CheckBoxEnableStandardContextMenu);
			this.Controls.Add(this.ButtonOrder);
			this.Controls.Add(this.ButtonAbout);
			this.MaximizeBox = false;
			this.Name = "MainForm";
			this.Text = "Sample 1 - SWF Player and FLV Player";
			this.Load += new System.EventHandler(this.MainForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.trackBarSoundVolume)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			openFileDialogFlashFile.InitialDirectory = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
			CheckBoxEnableStandardContextMenu.Checked = f_in_box__control1.StandardMenu;
			CheckBoxEnableSounds.Checked = f_in_box__control1.AxCode.SoundEnabled;

			if (f_in_box__control1.AxCode.SoundEnabled)
				labelSoundVolume.Text = 
					(f_in_box__control1.AxCode.SoundVolume * 100 / f_in_box__lib.AxCode.MaxSoundVolume).ToString() + 
					" %";
			else
				labelSoundVolume.Text = "Disabled";

			trackBarSoundVolume.Enabled = f_in_box__control1.AxCode.SoundEnabled;

			trackBarSoundVolume.Minimum = 0;
			trackBarSoundVolume.Maximum = 100;
			trackBarSoundVolume.TickFrequency = 10;
			trackBarSoundVolume.Value = 
				f_in_box__control1.AxCode.SoundVolume * 100 / f_in_box__lib.AxCode.MaxSoundVolume;

	        f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.Embedded_Movies.movie.swf"));
		    f_in_box__control1.FlashMethod_Play();
		}

		private void ButtonPlayFlashFileFromFile_Click(object sender, System.EventArgs e)
		{
			if (openFileDialogFlashFile.ShowDialog() == DialogResult.OK)
			{
				String FlashFilePath = openFileDialogFlashFile.FileName;

				if (FlashFilePath.EndsWith(".swf"))
					f_in_box__control1.FlashProperty_Movie = FlashFilePath;
				else
				{
					// First way -- provide FLV content using ContentProvider
					// Additionally, see Sample2_SWF_FLV_Embedding
					// This way is useful when you provide FLV from memory, stream, database and so on
					// When you should play FLV from URL / local file, use the Second way (see below)
					/*
						ContentProvider ContentProvider = 
							new ContentProvider(f_in_box__control1.AxCode, FlashFilePath);
					
						f_in_box__control1.FlashProperty_FlashVars = "FLVPath=http://FLV/FlashVideo.flv";
						f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.Embedded_Movies.FLVPlayer.swf"));
					*/

					// Second way -- just provide URL for Flash
					f_in_box__control1.FlashProperty_FlashVars = "FLVPath=" + System.Web.HttpUtility.HtmlEncode("file://" + FlashFilePath);
					f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.Embedded_Movies.FLVPlayer.swf"));
				}

				f_in_box__control1.FlashMethod_Play();
			}
		}

		private void CheckBoxEnableStandardContextMenu_CheckedChanged(object sender, System.EventArgs e)
		{
			f_in_box__control1.StandardMenu = CheckBoxEnableStandardContextMenu.Checked;
		}

		private void CheckBoxEnableSounds_CheckedChanged(object sender, System.EventArgs e)
		{
			f_in_box__control1.AxCode.SoundEnabled = CheckBoxEnableSounds.Checked;

			if (f_in_box__control1.AxCode.SoundEnabled)
				labelSoundVolume.Text = 
					(f_in_box__control1.AxCode.SoundVolume * 100 / f_in_box__lib.AxCode.MaxSoundVolume).ToString() + 
					" %";
			else
				labelSoundVolume.Text = "Disabled";

			trackBarSoundVolume.Enabled = f_in_box__control1.AxCode.SoundEnabled;
		}

		private void ButtonAbout_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/");
		}

		private void ButtonOrder_Click(object sender, System.EventArgs e)
		{
			System.Diagnostics.Process.Start("http://www.f-in-box.com/dotnet/order.html");
		}

		private void trackBarSoundVolume_Scroll(object sender, System.EventArgs e)
		{
			f_in_box__control1.AxCode.SoundVolume = 
				(ushort)(trackBarSoundVolume.Value * f_in_box__lib.AxCode.MaxSoundVolume / 100);

			labelSoundVolume.Text = 
				(f_in_box__control1.AxCode.SoundVolume * 100 / f_in_box__lib.AxCode.MaxSoundVolume).ToString() + 
				" %";
		}

		private void ButtonPlayFlashFileFromURL_Click(object sender, System.EventArgs e)
		{
			FormURL FormURL = new FormURL();

			if (DialogResult.OK == FormURL.ShowDialog())
			{
				if (FormURL.IsFLV)
				{
					// First way -- provide FLV content using ContentProvider
					// Additionally, see Sample2_SWF_FLV_Embedding
					// This way is useful when you provide FLV from memory, stream, database and so on
					// When you should play FLV from URL / local file, use the Second way (see below)
					/*
					ContentProviderFromURL ContentProvider = 
						new ContentProviderFromURL(f_in_box__control1.AxCode, FormURL.URL);
					
					f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.Embedded_Movies.FLVPlayer.swf"));
					f_in_box__control1.FlashMethod_Play();
					*/

					// Second way -- just provide URL for Flash
					f_in_box__control1.FlashProperty_FlashVars = "FLVPath=" + System.Web.HttpUtility.HtmlEncode(FormURL.URL);
					f_in_box__control1.PutMovieFromStream(this.GetType().Assembly.GetManifestResourceStream("Sample01_SWF_And_FLV_Player.Embedded_Movies.FLVPlayer.swf"));
				}
				else
				{
					f_in_box__control1.FlashProperty_Movie = FormURL.URL;
				}

				f_in_box__control1.FlashMethod_Play();
			}
		}
	}

	class FromStreamToStreamWriter
	{
		internal System.IO.Stream FromStream, ToStream;
		internal System.Threading.Thread Thread;

		public FromStreamToStreamWriter(System.IO.Stream FromStream, System.IO.Stream ToStream)
		{
			this.FromStream = FromStream;
			this.ToStream = ToStream;

			Thread = new System.Threading.Thread(new System.Threading.ThreadStart(Main));

			Thread.Start();
		}

		private void Main()
		{
			const int nSize = 64 * 1024;
			byte[] buffer = new byte[nSize];

			int nReadBytes;

			while (true)
			{
				nReadBytes = FromStream.Read(buffer, 0, nSize);

				if (0 == nReadBytes)
					break;

				try
				{
					ToStream.Write(buffer, 0, nReadBytes);
				}
				catch (System.IO.IOException /* e */ )
				{
					// Loading is interrupted
					break;
				}
			}

			FromStream.Close();
			ToStream.Close();
		}
	}

	class ContentProvider
	{
		private String Path;
		private f_in_box__lib.AxCode AxCode;
		private f_in_box__lib.AxCode.OnLoadExternalResourceByFullPathEventHandler Handler;

		public ContentProvider(f_in_box__lib.AxCode AxCode, String Path)
		{
			this.Path = Path;
			this.AxCode = AxCode;

			Handler = new f_in_box__lib.AxCode.OnLoadExternalResourceByFullPathEventHandler(OnLoadExternalResourceByFullPath);

			AxCode.OnLoadExternalResourceByFullPath += Handler;
		}

		private void OnLoadExternalResourceByFullPath(object sender, String URL, System.IO.Stream Stream, ref bool Handled)
		{
			if (URL == "http://FLV/FlashVideo.flv")
			{
				System.IO.Stream FromStream = System.IO.File.OpenRead(Path);

				FromStreamToStreamWriter writer = 
					new FromStreamToStreamWriter(
						FromStream, 
						Stream
					);

				Handled = true;

				AxCode.OnLoadExternalResourceByFullPath -= Handler;
			}
		}
	}

	class ContentProviderFromURL
	{
		private String URL;
		private f_in_box__lib.AxCode AxCode;
		private f_in_box__lib.AxCode.OnLoadExternalResourceByFullPathEventHandler Handler;
		private System.IO.Stream ToStream;

		public ContentProviderFromURL(f_in_box__lib.AxCode AxCode, String URL)
		{
			this.URL = URL;
			this.AxCode = AxCode;

			Handler = new f_in_box__lib.AxCode.OnLoadExternalResourceByFullPathEventHandler(OnLoadExternalResourceByFullPath);

			AxCode.OnLoadExternalResourceByFullPath += Handler;
		}

		private void Main()
		{
			System.IO.Stream FromStream = null;

			try
			{
				System.Net.HttpWebRequest request = (System.Net.HttpWebRequest)System.Net.HttpWebRequest.Create(URL);

				FromStream = request.GetResponse().GetResponseStream();

				const int nSize = 64 * 1024;
				byte[] buffer = new byte[nSize];

				int nReadBytes;

				while (true)
				{
					nReadBytes = FromStream.Read(buffer, 0, nSize);

					if (0 == nReadBytes)
						break;

					try
					{
						ToStream.Write(buffer, 0, nReadBytes);
					}
					catch (System.IO.IOException /* e */ )
					{
						// Loading is interrupted
						break;
					}
				}
			}

			catch (System.Exception e)
			{
				MessageBox.Show(e.ToString());
			}

			if (null != FromStream)
				FromStream.Close();

			ToStream.Close();
		}

		private void OnLoadExternalResourceByFullPath(object sender, String URL, System.IO.Stream Stream, ref bool Handled)
		{
			if (URL == "http://FLV/FlashVideo.flv")
			{
				ToStream = Stream;

				new System.Threading.Thread(new System.Threading.ThreadStart(Main)).Start();

				Handled = true;

				AxCode.OnLoadExternalResourceByFullPath -= Handler;
			}
		}
	}
}
