{$R 'res\movie.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FlashPlayerControl, StdCtrls, ShellApi;

type
  TMainForm = class(TForm)
    FlashPlayerControl1: TFlashPlayerControl;
    ButtonSite: TButton;
    ButtonOrder: TButton;
    Label1: TLabel;
    OpenJPEGDialog: TOpenDialog;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ButtonSiteClick(Sender: TObject);
    procedure ButtonOrderClick(Sender: TObject);
    procedure FlashPlayerControl1LoadExternalResource(ASender: TObject;
      const URL: WideString; Stream: TStream);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  ResourceStream: TResourceStream;
  UsingFlashVersion: TFlashVersion;
begin
  GetUsingFlashVersion(UsingFlashVersion);

  // Minimum version must be 7.*.*.*, so let's check high version component
  if UsingFlashVersion.version[3] < 7 then
  begin
    ShowMessage(Format('The Sample needs Flash 7 or higher to play embedded movie' + #13 + 'Current version of Flash: %d.%d.%d.%d', [ UsingFlashVersion.version[3], UsingFlashVersion.version[2], UsingFlashVersion.version[1], UsingFlashVersion.version[0] ]));
    Exit;
  end;

  ResourceStream := TResourceStream.Create(0, 'Movie', 'SWF');
  FlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
  ResourceStream.Free;

  OpenJPEGDialog.InitialDir := ExtractFileDir(Application.ExeName);
end;

procedure TMainForm.ButtonSiteClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonOrderClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/order.html?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.FlashPlayerControl1LoadExternalResource(
  ASender: TObject; const URL: WideString; Stream: TStream);
var
  ResourceStream: TResourceStream;
  MemoryStream: TMemoryStream;
begin
  if URL = 'images/embedded_image1.jpg' then
  begin
    ResourceStream := TResourceStream.Create(0, 'image1', 'IMAGE');
    ResourceStream.SaveToStream(Stream);
    ResourceStream.Free;
  end;

  if URL = 'images/embedded_image2.jpg' then
  begin
    ResourceStream := TResourceStream.Create(0, 'image2', 'IMAGE');
    ResourceStream.SaveToStream(Stream);
    ResourceStream.Free;
  end;

  if URL = 'images/embedded_image3.jpg' then
  begin
    ResourceStream := TResourceStream.Create(0, 'image3', 'IMAGE');
    ResourceStream.SaveToStream(Stream);
    ResourceStream.Free;
  end;

  if URL = 'images/embedded_image4.jpg' then
  begin
    ResourceStream := TResourceStream.Create(0, 'image4', 'IMAGE');
    ResourceStream.SaveToStream(Stream);
    ResourceStream.Free;
  end;

  if URL = 'images/embedded_image5.jpg' then
  begin
    ResourceStream := TResourceStream.Create(0, 'image5', 'IMAGE');
    ResourceStream.SaveToStream(Stream);
    ResourceStream.Free;
  end;

  if URL = 'images/external_image.jpg' then
  begin
    if OpenJPEGDialog.Execute then
    begin
      MemoryStream := TMemoryStream.Create;
      MemoryStream.LoadFromFile(OpenJPEGDialog.FileName);
      MemoryStream.SaveToStream(Stream);
      MemoryStream.Free;
    end;
  end;
end;

var
  FlashOcxFileName: string;
  FlashCodeStream: TStream;

initialization

FlashOcxFileName :=
{$IFDEF WIN64}
  'Flash64_32_0_0_371.ocx';
{$ELSE}
  'Flash32_32_0_0_371.ocx';
{$ENDIF}

  if Not IsFlashInstalled then
  begin
    FlashCodeStream := TFileStream.Create(ExpandFileName(ExtractFileDir(Application.ExeName) + '\' + FlashOcxFileName), fmOpenRead);
    try
      FlashPlayerControl.LoadFlashOCXCodeFromStream(FlashCodeStream);
    finally
      FlashCodeStream.Free;
    end;
  end;

end.
