{$R 'res\movie.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FlashPlayerControl, Menus, ShellApi;

type
  TMainForm = class(TForm)
    TransparentFlashPlayerControl1: TTransparentFlashPlayerControl;
    PopupMenu: TPopupMenu;
    CloseMenuItem: TMenuItem;
    MinimizeMenuItem: TMenuItem;
    N1: TMenuItem;
    AboutFINBOX1: TMenuItem;
    Buylicense1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure TransparentFlashPlayerControl1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure TransparentFlashPlayerControl1MouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure CloseMenuItemClick(Sender: TObject);
    procedure MinimizeMenuItemClick(Sender: TObject);
    procedure AboutFINBOX1Click(Sender: TObject);
    procedure Buylicense1Click(Sender: TObject);
  private
    FStartPoint: TPoint;
    FWindowLeftTop: TPoint;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  ResourceStream: TResourceStream;
begin
  if Not IsFormTransparentAvailable then
  begin
    ShowMessage('Transluency based on Flash is not available');
    Application.Terminate;
  end;

  TransparentFlashPlayerControl1.MakeParentTransparent := True;
  ResourceStream := TResourceStream.Create(0, 'Movie', 'FLASH');
  TransparentFlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
  TransparentFlashPlayerControl1.Play;
  ResourceStream.Free;
end;

procedure TMainForm.TransparentFlashPlayerControl1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if not MouseCapture then
  begin
    MouseCapture := True;
    FStartPoint.X := X;
    FStartPoint.Y := Y;
    FStartPoint := TransparentFlashPlayerControl1.ClientToScreen(FStartPoint);
    FWindowLeftTop.X := Left;
    FWindowLeftTop.Y := Top;
  end;
end;

procedure TMainForm.TransparentFlashPlayerControl1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  MouseCapture := False;
end;

procedure TMainForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  pt: TPoint;
begin
  if MouseCapture then
  begin
    pt.X := X;
    pt.Y := Y;
    pt := ClientToScreen(pt);
    Left := pt.X + FWindowLeftTop.X - FStartPoint.X;
    Top := pt.Y + FWindowLeftTop.Y - FStartPoint.Y;
  end;
end;

procedure TMainForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = Char(VK_ESCAPE) then Close;
end;

procedure TMainForm.CloseMenuItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.MinimizeMenuItemClick(Sender: TObject);
begin
  Application.Minimize;
end;

procedure TMainForm.AboutFINBOX1Click(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.Buylicense1Click(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/order.html?from_program=1', nil, nil, SW_SHOW);
end;

var
  FlashOcxFileName: string;
  FlashCodeStream: TStream;

initialization

FlashOcxFileName :=
{$IFDEF WIN64}
  'Flash64_32_0_0_371.ocx';
{$ELSE}
  'Flash32_32_0_0_371.ocx';
{$ENDIF}

  if Not IsFlashInstalled then
  begin
    FlashCodeStream := TFileStream.Create(ExpandFileName(ExtractFileDir(Application.ExeName) + '\' + FlashOcxFileName), fmOpenRead);
    try
      FlashPlayerControl.LoadFlashOCXCodeFromStream(FlashCodeStream);
    finally
      FlashCodeStream.Free;
    end;
  end;

end.
