{$R 'res\movie.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FlashPlayerControl, StdCtrls, ShellApi, ComCtrls;

type
  TMainForm = class(TForm)
    FlashPlayerControl1: TFlashPlayerControl;
    ButtonPlayFLV: TButton;
    OpenDialogFLV: TOpenDialog;
    ButtonPlaySWF: TButton;
    OpenDialogSWF: TOpenDialog;
    CheckBoxEnableStandartFlashMenu: TCheckBox;
    CheckBoxEnableSounds: TCheckBox;
    CheckBoxTransparent: TCheckBox;
    TransparentFlashPlayerControl1: TTransparentFlashPlayerControl;
    ButtonSite: TButton;
    ButtonOrder: TButton;
    TrackBarSoundVolume: TTrackBar;
    LabelSoundVolume: TLabel;
    Label1: TLabel;
    EditFlashMovieURL: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    EditFLVURL: TEdit;
    ButtonPlaySWFFromURL: TButton;
    ButtonPlayFLVFromURL: TButton;
    procedure ButtonPlayFLVClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonPlaySWFClick(Sender: TObject);
    procedure CheckBoxEnableStandartFlashMenuClick(Sender: TObject);
    procedure CheckBoxEnableSoundsClick(Sender: TObject);
    procedure CheckBoxTransparentClick(Sender: TObject);
    procedure ButtonSiteClick(Sender: TObject);
    procedure ButtonOrderClick(Sender: TObject);
    procedure TrackBarSoundVolumeChange(Sender: TObject);
    procedure ButtonPlayFLVFromURLClick(Sender: TObject);
    procedure ButtonPlaySWFFromURLClick(Sender: TObject);
  private
    FFLVPath: String;
    FPlaySWF: Boolean;

    procedure OnGlobalLoadExternalResource(const URL: WideString; Stream: TStream);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.ButtonPlayFLVClick(Sender: TObject);
var
  UsingFlashVersion: TFlashVersion;
  ResourceStream: TResourceStream;
begin
  GetUsingFlashVersion(UsingFlashVersion);

  // Minimum version must be 7.*.*.*, so let's check high version component
  if UsingFlashVersion.version[3] < 7 then
  begin
    ShowMessage(Format('The Sample needs Flash 7 or higher to play Flash Video' + #13 + 'Current version of Flash: %d.%d.%d.%d', [ UsingFlashVersion.version[3], UsingFlashVersion.version[2], UsingFlashVersion.version[1], UsingFlashVersion.version[0] ]));
    Exit;
  end;

  if OpenDialogFLV.Execute then
  begin
    FPlaySWF := False;

    FFLVPath := OpenDialogFLV.FileName;

    ResourceStream := TResourceStream.Create(0, 'FLVPlayer', 'FLASH');

    if FlashPlayerControl1.Visible then
    begin
      FlashPlayerControl1.FlashVars := 'FLVPath=' + FFLVPath;
      FlashPlayerControl1.PutMovieFromStream(ResourceStream);
    end
    else
    begin
      TransparentFlashPlayerControl1.FlashVars := 'FLVPath=' + FFLVPath;
      TransparentFlashPlayerControl1.PutMovieFromStream(ResourceStream);
    end;

    ResourceStream.Free;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  SetGlobalOnLoadExternalResourceHandler(OnGlobalLoadExternalResource);

  OpenDialogFLV.InitialDir := ExtractFileDir(Application.ExeName);
  OpenDialogSWF.InitialDir := ExtractFileDir(Application.ExeName);

  CheckBoxEnableStandartFlashMenu.Checked := FlashPlayerControl1.StandartMenu;
  CheckBoxEnableSounds.Checked := FlashPlayerControl.GetAudioEnabled;

  CheckBoxTransparent.Checked := TransparentFlashPlayerControl1.Visible;

  FlashPlayerControl1.Movie := ExtractFileDir(Application.ExeName) + '\movie.swf';
  FlashPlayerControl1.Play;

  TransparentFlashPlayerControl1.Movie := ExtractFileDir(Application.ExeName) + '\movie.swf';
  TransparentFlashPlayerControl1.Play;

  FPlaySWF := True;

  TrackBarSoundVolume.Position := FlashPlayerControl.GetAudioVolume;  
  LabelSoundVolume.Caption := Format( '%d %%', [ TrackBarSoundVolume.Position ] );
end;

procedure TMainForm.OnGlobalLoadExternalResource(const URL: WideString; Stream: TStream);
var
  FileStream: TFileStream;
  MemoryStream: TMemoryStream;
begin
  if URL = 'http://FLV/FlashVideo.flv' then
  begin
    if Length(FFLVPath) > 0 then
    begin
      FileStream := TFileStream.Create(FFLVPath, fmOpenRead);
      MemoryStream := TMemoryStream.Create;
      MemoryStream.LoadFromStream(FileStream);
      MemoryStream.SaveToStream(Stream);
      FileStream.Free;
      MemoryStream.Free;
    end;
  end;
end;

procedure TMainForm.ButtonPlaySWFClick(Sender: TObject);
begin
  if OpenDialogSWF.Execute then
  begin
    FPlaySWF := True;

    if FlashPlayerControl1.Visible then
    begin
      FlashPlayerControl1.Movie := OpenDialogSWF.FileName;
      FlashPlayerControl1.Play;
    end
    else
    begin
      TransparentFlashPlayerControl1.Movie := OpenDialogSWF.FileName;
      TransparentFlashPlayerControl1.Play;
    end;
  end;
end;

procedure TMainForm.CheckBoxEnableStandartFlashMenuClick(Sender: TObject);
begin
  FlashPlayerControl1.StandartMenu := CheckBoxEnableStandartFlashMenu.Checked;
  TransparentFlashPlayerControl1.StandartMenu := CheckBoxEnableStandartFlashMenu.Checked;
end;

procedure TMainForm.CheckBoxEnableSoundsClick(Sender: TObject);
begin
  FlashPlayerControl.SetAudioEnabled(CheckBoxEnableSounds.Checked);

  TrackBarSoundVolume.Enabled := CheckBoxEnableSounds.Checked;

  if CheckBoxEnableSounds.Checked then
    LabelSoundVolume.Caption := Format( '%d %%', [ TrackBarSoundVolume.Position ] )
  else
    LabelSoundVolume.Caption := 'Sound disabled';
end;

procedure TMainForm.CheckBoxTransparentClick(Sender: TObject);
var
  MoviePath: String;
  ResourceStream: TResourceStream;
begin
  FlashPlayerControl1.Visible := Not CheckBoxTransparent.Checked;
  TransparentFlashPlayerControl1.Visible := CheckBoxTransparent.Checked;

  if FPlaySWF then
  begin
    if FlashPlayerControl1.Visible then
    begin
      MoviePath := TransparentFlashPlayerControl1.Movie;

      if Length(MoviePath) > 0 then
      begin
        TransparentFlashPlayerControl1.Movie := '_';
        FlashPlayerControl1.Movie := MoviePath;
        FlashPlayerControl1.Play;
      end;
    end
    else
    begin
      MoviePath := FlashPlayerControl1.Movie;

      if Length(MoviePath) > 0 then
      begin
        FlashPlayerControl1.Movie := '_';
        TransparentFlashPlayerControl1.Movie := MoviePath;
        TransparentFlashPlayerControl1.Play;
      end;
    end;
  end
  else
  begin
    ResourceStream := TResourceStream.Create(0, 'FLVPlayer', 'FLASH');

    if FlashPlayerControl1.Visible then
    begin
      FlashPlayerControl1.FlashVars := 'FLVPath=' + FFLVPath;
      FlashPlayerControl1.PutMovieFromStream(ResourceStream);
    end
    else
    begin
      TransparentFlashPlayerControl1.FlashVars := 'FLVPath=' + FFLVPath;
      TransparentFlashPlayerControl1.PutMovieFromStream(ResourceStream);
    end;

    ResourceStream.Free;
  end;
end;

procedure TMainForm.ButtonSiteClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonOrderClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/order.html?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.TrackBarSoundVolumeChange(Sender: TObject);
begin
   FlashPlayerControl.SetAudioVolume(TrackBarSoundVolume.Position);
   LabelSoundVolume.Caption := Format( '%d %%', [ TrackBarSoundVolume.Position ] );
end;

procedure TMainForm.ButtonPlayFLVFromURLClick(Sender: TObject);
var
  UsingFlashVersion: TFlashVersion;
  ResourceStream: TResourceStream;
begin
  GetUsingFlashVersion(UsingFlashVersion);

  // Minimum version must be 7.*.*.*, so let's check high version component
  if UsingFlashVersion.version[3] < 7 then
  begin
    ShowMessage(Format('The Sample needs Flash 7 or higher to play Flash Video' + #13 + 'Current version of Flash: %d.%d.%d.%d', [ UsingFlashVersion.version[3], UsingFlashVersion.version[2], UsingFlashVersion.version[1], UsingFlashVersion.version[0] ]));
    Exit;
  end;

    FPlaySWF := False;

    FFLVPath := EditFLVURL.Text;

    ResourceStream := TResourceStream.Create(0, 'FLVPlayer', 'FLASH');

    if FlashPlayerControl1.Visible then
    begin
      // This is a simple example; if EditFlashMovieURL.Text contains '?'
      // and so on, you should urlencode it
      FlashPlayerControl1.FlashVars := 'FLVPath=' + FFLVPath;
      FlashPlayerControl1.PutMovieFromStream(ResourceStream);
    end
    else
    begin
      // This is a simple example; if EditFlashMovieURL.Text contains '?'
      // and so on, you should urlencode it
      TransparentFlashPlayerControl1.FlashVars := 'FLVPath=' + FFLVPath;
      TransparentFlashPlayerControl1.PutMovieFromStream(ResourceStream);
    end;

    ResourceStream.Free;
end;

procedure TMainForm.ButtonPlaySWFFromURLClick(Sender: TObject);
begin
    FPlaySWF := True;

    if FlashPlayerControl1.Visible then
    begin
      FlashPlayerControl1.Movie := EditFlashMovieURL.Text;
      FlashPlayerControl1.Play;
    end
    else
    begin
      TransparentFlashPlayerControl1.Movie := EditFlashMovieURL.Text;
      TransparentFlashPlayerControl1.Play;
    end;
end;

var
  FlashOcxFileName: string;
  FlashCodeStream: TStream;

initialization

FlashOcxFileName :=
{$IFDEF WIN64}
  'Flash64_32_0_0_371.ocx';
{$ELSE}
  'Flash32_32_0_0_371.ocx';
{$ENDIF}

  if Not IsFlashInstalled then
  begin
    FlashCodeStream := TFileStream.Create(ExpandFileName(ExtractFileDir(Application.ExeName) + '\' + FlashOcxFileName), fmOpenRead);
    try
      FlashPlayerControl.LoadFlashOCXCodeFromStream(FlashCodeStream);
    finally
      FlashCodeStream.Free;
    end;
  end;

end.
