//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "FlashPlayerControl"
#pragma resource "*.dfm"
#pragma resource "res\\movie.res"
TMainForm *MainForm;

#define VERIFY(expr)    if (!(expr)) DebugBreak();

//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner), FStarted(false), Fhmmio(NULL), FPWaveFormatEx(NULL)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  if (!Flashplayercontrol::IsFlashInstalled())
  {
    ShowMessage("The application needs Flash\nFlash is not installed");
    Application->Terminate();
  }

  SetGlobalOnLoadExternalResourceHandler(OnGlobalLoadExternalResource);

  OpenDialogSWF->InitialDir = ExtractFileDir(Application->ExeName);
  OpenDialogFLV->InitialDir = ExtractFileDir(Application->ExeName);
  SaveDialogWAV->InitialDir = ExtractFileDir(Application->ExeName);

  FPlaySWF = true;

  Flashplayercontrol::SetAudioOutputOpenHandler(&OnAudioOutputOpen);
  Flashplayercontrol::SetAudioOutputWriteHandler(&OnAudioOutputWrite);
  Flashplayercontrol::SetAudioOutputCloseHandler(&OnAudioOutputClose);

  ShowMessage("If you use demo version of the component, it saves only first 15 seconds of the audio");
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonOrderClick(TObject *Sender)
{
  ShellExecute(0, NULL, "http://www.f-in-box.com/delphi/order.html", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonPlayFLVClick(TObject *Sender)
{
  TFlashVersion UsingFlashVersion;
  Flashplayercontrol::GetUsingFlashVersion(UsingFlashVersion);

  // Check high version component, i.e. flash version must be at least 7.*.*.*
  if (UsingFlashVersion.version[3] < 7)
  {
    char Message[1024];
    wsprintf(Message, "The Sample needs Flash 7 or higher to play Flash Video\nCurrent version of Flash: %d.%d.%d.%d", UsingFlashVersion.version[3], UsingFlashVersion.version[2], UsingFlashVersion.version[1], UsingFlashVersion.version[0]);
    ShowMessage(Message);
    return;
  }

  if (OpenDialogFLV->Execute())
  {
    if (CheckBoxAutoRecording->Checked)
      ButtonStartRecordingClick(this);

    FPlaySWF = false;

    FFLVPath = OpenDialogFLV->FileName;

    TResourceStream* ResourceStream = new TResourceStream(0, "FLVPlayer", "FLASH");

    FlashPlayerControl1->FlashVars = "FLVPath=" + FFLVPath;
    FlashPlayerControl1->PutMovieFromStream(ResourceStream);
    FlashPlayerControl1->Play();

    delete ResourceStream;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonPlaySWFClick(TObject *Sender)
{
  if (OpenDialogSWF->Execute())
  {
    if (CheckBoxAutoRecording->Checked)
      ButtonStartRecordingClick(this);

    FPlaySWF = true;

    FlashPlayerControl1->Movie = OpenDialogSWF->FileName;
    FlashPlayerControl1->Play();
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonSiteClick(TObject *Sender)
{
  ShellExecute(0, NULL, "http://www.f-in-box.com/delphi/", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::OnGlobalLoadExternalResource(const WideString URL, Classes::TStream* Stream)
{
  if (URL == WideString("http://FLV/FlashVideo.flv"))
    if (FFLVPath.Length() > 0)
    {
      TFileStream* FileStream = new TFileStream(FFLVPath, fmOpenRead);
      TMemoryStream* MemoryStream = new TMemoryStream;
      MemoryStream->LoadFromStream(FileStream);
      MemoryStream->SaveToStream(Stream);
      delete FileStream;
      delete MemoryStream;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonBrowseWAVFileClick(TObject *Sender)
{
   if (SaveDialogWAV->Execute())
        EditWAVPath->Text = SaveDialogWAV->FileName;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonStartRecordingClick(TObject *Sender)
{
   if (FStarted)
      return;

   EditWAVPath->Enabled = false;
   ButtonStartRecording->Enabled = false;
   ButtonBrowseWAVFile->Enabled = false;
   ButtonStopRecording->Enabled = true;
   CheckBoxAutoRecording->Enabled = false;

   FStarted = true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonStopRecordingClick(TObject *Sender)
{
   if (0 != Fhmmio)
   {
      mmioClose(Fhmmio, 0);
      Fhmmio = 0;
   }

   EditWAVPath->Enabled = true;
   ButtonStartRecording->Enabled = true;
   ButtonBrowseWAVFile->Enabled = true;
   ButtonStopRecording->Enabled = false;
   CheckBoxAutoRecording->Enabled = true;

   FStarted = false;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::OnAudioOutputOpen(PWaveFormatEx lpFormat)
{
   if (NULL != FPWaveFormatEx)
        delete (char*)FPWaveFormatEx;

   int nSize = sizeof(*lpFormat) + lpFormat->cbSize;
   FPWaveFormatEx = (PWAVEFORMATEX)new char[nSize];
   CopyMemory(FPWaveFormatEx, lpFormat, nSize);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::OnAudioOutputWrite(PWaveHdr lpWaveOutHdr, unsigned uSize)
{
        if (!FStarted)
                return;

	if (NULL == Fhmmio)
	{
		Fhmmio = mmioOpen(EditWAVPath->Text.c_str(), NULL, MMIO_ALLOCBUF | MMIO_CREATE | MMIO_WRITE);

		MMCKINFO wave = { 0 };
		wave.fccType = mmioFOURCC('W','A','V','E');
		VERIFY(MMSYSERR_NOERROR == mmioCreateChunk(Fhmmio, &wave, MMIO_CREATERIFF));

		MMCKINFO fmt = { 0 };
		fmt.ckid = mmioFOURCC('f','m','t',' ');
		fmt.cksize = sizeof(WAVEFORMATEX) + FPWaveFormatEx->cbSize;
		VERIFY(MMSYSERR_NOERROR == mmioCreateChunk(Fhmmio, &fmt, 0));
		VERIFY(fmt.cksize == mmioWrite(Fhmmio, (LPCSTR)FPWaveFormatEx, fmt.cksize));

		VERIFY(MMSYSERR_NOERROR == mmioAscend(Fhmmio, &fmt, 0));

		MMCKINFO data = { 0 };
		data.ckid = mmioFOURCC('d','a','t','a');
		VERIFY(MMSYSERR_NOERROR == mmioCreateChunk(Fhmmio, &data, 0));
	}

	VERIFY(lpWaveOutHdr->dwBufferLength == mmioWrite(Fhmmio, lpWaveOutHdr->lpData, lpWaveOutHdr->dwBufferLength));
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::OnAudioOutputClose(void)
{
  ButtonStopRecordingClick(this);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormDestroy(TObject *Sender)
{
  Flashplayercontrol::SetAudioOutputOpenHandler(NULL);
  Flashplayercontrol::SetAudioOutputWriteHandler(NULL);
  Flashplayercontrol::SetAudioOutputCloseHandler(NULL);

  if (NULL != FPWaveFormatEx)
    delete (char*)FPWaveFormatEx;
}
//---------------------------------------------------------------------------

