//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainUnit.h"
#include "EncodingThread.h"
#include "ContentProviderThread.h"
#include "ProgressForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "FlashPlayerControl"
#pragma resource "*.dfm"
#pragma resource "res\\movie.res"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  if (!Flashplayercontrol::IsFlashInstalled())
  {
    ShowMessage("The application needs Flash\nFlash is not installed");
    Application->Terminate();
  }

  Flashplayercontrol::SetGlobalOnLoadExternalResourceHandlerEx(ContentProvider);

  OpenDialogFLV->InitialDir = ExtractFileDir(Application->ExeName);
  OpenDialogSWF->InitialDir = ExtractFileDir(Application->ExeName);
  OpenDialogFlashFiles->InitialDir = ExtractFileDir(Application->ExeName);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ContentProvider(const WideString URL, TStream* Stream, bool& bHandled)
{
  if (URL == WideString("http://FLV/FlashVideo.flv"))
  {
    unsigned int Speed;

    if (MainForm->ComboBoxSpeed->Text == "<unlimited>")
       Speed = 1024 * 1024; // big speed
    else
       Speed = StrToInt(MainForm->ComboBoxSpeed->Text);

    TContentProviderThread* ContentProviderThread = new TContentProviderThread(FEncodedFLVStream, Stream, Speed);

    bHandled = true;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonOrderClick(TObject *Sender)
{
  ShellExecute(0, NULL, "http://www.f-in-box.com/delphi/order.html", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonSiteClick(TObject *Sender)
{
  ShellExecute(0, NULL, "http://www.f-in-box.com/delphi/", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonEncodeClick(TObject *Sender)
{
   if (OpenDialogFlashFiles->Execute())
      if (SaveDialogEncodedFlashFiles->Execute())
      {
         TFileStream* SourceStream = new TFileStream(OpenDialogFlashFiles->FileName, fmOpenRead | fmShareDenyWrite);
         TStream* DestStream = new TFileStream(SaveDialogEncodedFlashFiles->FileName, fmCreate | fmOpenWrite);

         bool IsSWF;

         if (AnsiLowerCase(ExtractFileExt(OpenDialogFlashFiles->FileName)) == ".swf")
            IsSWF = true;
         else
            IsSWF = false;

         // Encoding (very simple)
         DestStream->Write(&IsSWF, sizeof(IsSWF));

         TEncodingThread* EncodingThread = new TEncodingThread(SourceStream, DestStream, SourceStream->Size);

         MainForm->Enabled = false;

         ProgressForm = new TProgressForm(this, EncodingThread);
      }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonPlayEncodedClick(TObject *Sender)
{
   if (OpenDialogEncodedFlashFiles->Execute())
   {
      unsigned int Speed;

      if (MainForm->ComboBoxSpeed->Text == "<unlimited>")
         Speed = 1024 * 1024; // big speed
      else
         Speed = StrToInt(MainForm->ComboBoxSpeed->Text);

      TStream* SourceStream = new TFileStream(OpenDialogEncodedFlashFiles->FileName, fmOpenRead | fmShareDenyWrite);

      bool IsSWF;
      SourceStream->Read(&IsSWF, sizeof(IsSWF));

      if (IsSWF)
      {
         TStream* MovieStream;
         FlashPlayerControl1->LoadMovieUsingStream(0, MovieStream);
         TContentProviderThread* ContentProviderThread = new TContentProviderThread(SourceStream, MovieStream, Speed);
      }
      else
      {
         FEncodedFLVStream = SourceStream;

         FlashPlayerControl1->FlashVars = "FLVPath=http://FLV/FlashVideo.flv";

         TStream* ResourceStream = new TResourceStream(0, "FLVPlayer", "FLASH");

         FlashPlayerControl1->PutMovieFromStream(ResourceStream);

         ResourceStream->Free();
      }
   }
}
//---------------------------------------------------------------------------


