//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "FlashPlayerControl"
#pragma resource "*.dfm"
#pragma resource "res\\movie.res"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  if (!Flashplayercontrol::IsFlashInstalled())
  {
    ShowMessage("The application needs Flash\nFlash is not installed");
    Application->Terminate();
  }

  SetGlobalOnLoadExternalResourceHandler(OnGlobalLoadExternalResource);

  OpenDialogSWF->InitialDir = ExtractFileDir(Application->ExeName);
  OpenDialogFLV->InitialDir = ExtractFileDir(Application->ExeName);

  CheckBoxEnableStandartFlashMenu->Checked = FlashPlayerControl1->StandartMenu;
  CheckBoxEnableSounds->Checked = Flashplayercontrol::GetAudioEnabled();

  CheckBoxTransparent->Checked = TransparentFlashPlayerControl1->Visible;

  FlashPlayerControl1->Movie = ExtractFileDir(Application->ExeName) + "\\movie.swf";
  FlashPlayerControl1->Play();

  FPlaySWF = true;

  TrackBarSoundVolume->Position = Flashplayercontrol::GetAudioVolume();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonOrderClick(TObject *Sender)
{
  ShellExecute(0, NULL, "http://www.f-in-box.com/delphi/order.html", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonPlayFLVClick(TObject *Sender)
{
  TFlashVersion UsingFlashVersion;
  Flashplayercontrol::GetUsingFlashVersion(UsingFlashVersion);

  // Check high version component, i.e. flash version must be at least 7.*.*.*
  if (UsingFlashVersion.version[3] < 7)
  {
    char Message[1024];
    wsprintf(Message, "The Sample needs Flash 7 or higher to play Flash Video\nCurrent version of Flash: %d.%d.%d.%d", UsingFlashVersion.version[3], UsingFlashVersion.version[2], UsingFlashVersion.version[1], UsingFlashVersion.version[0]);
    ShowMessage(Message);
    return;
  }

  if (OpenDialogFLV->Execute())
  {
    FPlaySWF = false;

    FFLVPath = OpenDialogFLV->FileName;

    TResourceStream* ResourceStream = new TResourceStream(0, "FLVPlayer", "FLASH");

    if (FlashPlayerControl1->Visible)
    {
      FlashPlayerControl1->FlashVars = "FLVPath=" + FFLVPath;
      FlashPlayerControl1->PutMovieFromStream(ResourceStream);
      FlashPlayerControl1->Play();
    }
    else
    {
      TransparentFlashPlayerControl1->FlashVars = "FLVPath=" + FFLVPath;
      TransparentFlashPlayerControl1->PutMovieFromStream(ResourceStream);
      TransparentFlashPlayerControl1->Play();
    }

    delete ResourceStream;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonPlaySWFClick(TObject *Sender)
{
  if (OpenDialogSWF->Execute())
  {
    FPlaySWF = true;

    if (FlashPlayerControl1->Visible)
    {
      FlashPlayerControl1->Movie = OpenDialogSWF->FileName;
      FlashPlayerControl1->Play();
    }
    else
    {
      TransparentFlashPlayerControl1->Movie = OpenDialogSWF->FileName;
      TransparentFlashPlayerControl1->Play();
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonSiteClick(TObject *Sender)
{
  ShellExecute(0, NULL, "http://www.f-in-box.com/delphi/", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CheckBoxEnableSoundsClick(TObject *Sender)
{
  Flashplayercontrol::SetAudioEnabled(CheckBoxEnableSounds->Checked);

  TrackBarSoundVolume->Enabled = CheckBoxEnableSounds->Checked;

  if (CheckBoxEnableSounds->Checked)
     LabelSoundVolume->Caption = IntToStr(Flashplayercontrol::GetAudioVolume()) + " %";
  else
     LabelSoundVolume->Caption = "Sound disabled";
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CheckBoxEnableStandartFlashMenuClick(
      TObject *Sender)
{
  FlashPlayerControl1->StandartMenu = CheckBoxEnableStandartFlashMenu->Checked;
  TransparentFlashPlayerControl1->StandartMenu = CheckBoxEnableStandartFlashMenu->Checked;
}
//---------------------------------------------------------------------------


void __fastcall TMainForm::OnGlobalLoadExternalResource(const WideString URL, Classes::TStream* Stream)
{
  if (URL == WideString("http://FLV/FlashVideo.flv"))
    if (FFLVPath.Length() > 0)
    {
      TFileStream* FileStream = new TFileStream(FFLVPath, fmOpenRead);
      TMemoryStream* MemoryStream = new TMemoryStream;
      MemoryStream->LoadFromStream(FileStream);
      MemoryStream->SaveToStream(Stream);
      delete FileStream;
      delete MemoryStream;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CheckBoxTransparentClick(TObject *Sender)
{
  FlashPlayerControl1->Visible = !CheckBoxTransparent->Checked;
  TransparentFlashPlayerControl1->Visible = CheckBoxTransparent->Checked;

  if (FPlaySWF)
  {
    if (FlashPlayerControl1->Visible)
    {
      WideString MoviePath = TransparentFlashPlayerControl1->Movie;

      if (MoviePath.Length() > 0)
      {
        TransparentFlashPlayerControl1->Movie = "_";
        FlashPlayerControl1->Movie = MoviePath;
        FlashPlayerControl1->Play();
      }
    }
    else
    {
      WideString MoviePath = FlashPlayerControl1->Movie;

      if (MoviePath.Length() > 0)
      {
        FlashPlayerControl1->Movie = "_";
        TransparentFlashPlayerControl1->Movie = MoviePath;
        TransparentFlashPlayerControl1->Play();
      }
    }
  }
  else
  {
    TResourceStream* ResourceStream = new TResourceStream(0, "FLVPlayer", "FLASH");

    if (FlashPlayerControl1->Visible)
    {
      FlashPlayerControl1->FlashVars = "FLVPath=" + FFLVPath;
      FlashPlayerControl1->PutMovieFromStream(ResourceStream);
      FlashPlayerControl1->Play();
    }
    else
    {
      TransparentFlashPlayerControl1->FlashVars = "FLVPath=" + FFLVPath;
      TransparentFlashPlayerControl1->PutMovieFromStream(ResourceStream);
      TransparentFlashPlayerControl1->Play();
    }

    delete ResourceStream;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::TrackBarSoundVolumeChange(TObject *Sender)
{
   Flashplayercontrol::SetAudioVolume(TrackBarSoundVolume->Position);

   LabelSoundVolume->Caption = IntToStr(Flashplayercontrol::GetAudioVolume()) + " %";
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonPlaySWFFromURLClick(TObject *Sender)
{
    FPlaySWF = true;

    if (FlashPlayerControl1->Visible)
    {
      FlashPlayerControl1->Movie = EditFlashMovieURL->Text;
      FlashPlayerControl1->Play();
    }
    else
    {
      TransparentFlashPlayerControl1->Movie = EditFlashMovieURL->Text;
      TransparentFlashPlayerControl1->Play();
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonPlayFLVFromURLClick(TObject *Sender)
{
  TFlashVersion UsingFlashVersion;
  Flashplayercontrol::GetUsingFlashVersion(UsingFlashVersion);

  // Check high version component, i.e. flash version must be at least 7.*.*.*
  if (UsingFlashVersion.version[3] < 7)
  {
    char Message[1024];
    wsprintf(Message, "The Sample needs Flash 7 or higher to play Flash Video\nCurrent version of Flash: %d.%d.%d.%d", UsingFlashVersion.version[3], UsingFlashVersion.version[2], UsingFlashVersion.version[1], UsingFlashVersion.version[0]);
    ShowMessage(Message);
    return;
  }

    FPlaySWF = false;

    FFLVPath = EditFLVURL->Text;

    TResourceStream* ResourceStream = new TResourceStream(0, "FLVPlayer", "FLASH");

    if (FlashPlayerControl1->Visible)
    {
      FlashPlayerControl1->FlashVars = "FLVPath=" + FFLVPath;
      FlashPlayerControl1->PutMovieFromStream(ResourceStream);
      FlashPlayerControl1->Play();
    }
    else
    {
      TransparentFlashPlayerControl1->FlashVars = "FLVPath=" + FFLVPath;
      TransparentFlashPlayerControl1->PutMovieFromStream(ResourceStream);
      TransparentFlashPlayerControl1->Play();
    }

    delete ResourceStream;
}
//---------------------------------------------------------------------------

