{$R 'res\movie.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FlashPlayerControl, StdCtrls, ShellApi;

type
  TMainForm = class(TForm)
    FlashPlayerControl1: TFlashPlayerControl;
    ButtonPlayFLV: TButton;
    ButtonPlaySWF: TButton;
    CheckBoxEnableStandartFlashMenu: TCheckBox;
    CheckBoxEnableSounds: TCheckBox;
    CheckBoxTransparent: TCheckBox;
    TransparentFlashPlayerControl1: TTransparentFlashPlayerControl;
    ButtonSite: TButton;
    ButtonOrder: TButton;
    procedure ButtonPlayFLVClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonPlaySWFClick(Sender: TObject);
    procedure CheckBoxEnableStandartFlashMenuClick(Sender: TObject);
    procedure CheckBoxEnableSoundsClick(Sender: TObject);
    procedure CheckBoxTransparentClick(Sender: TObject);
    procedure ButtonSiteClick(Sender: TObject);
    procedure ButtonOrderClick(Sender: TObject);
  private
    FPlaySWF: Boolean;

    procedure OnGlobalLoadExternalResource(const URL: WideString; Stream: TStream);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.ButtonPlayFLVClick(Sender: TObject);
var
  ResourceStream: TResourceStream;
  UsingFlashVersion: TFlashVersion;
begin
  GetUsingFlashVersion(UsingFlashVersion);

  // Minimum version must be 7.*.*.*, so let's check high version component
  if UsingFlashVersion.version[3] < 7 then
  begin
    ShowMessage(Format('The Sample needs Flash 7 or higher to play Flash Video' + #13 + 'Current version of Flash: %d.%d.%d.%d', [ UsingFlashVersion.version[3], UsingFlashVersion.version[2], UsingFlashVersion.version[1], UsingFlashVersion.version[0] ]));
    Exit;
  end;

  FPlaySWF := False;

  ResourceStream := TResourceStream.Create(0, 'FLVPlayer', 'SWF');

  if FlashPlayerControl1.Visible then
  begin
    FlashPlayerControl1.FlashVars := 'FLVPath=http://FLV/FlashVideo.flv';
    FlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
    FlashPlayerControl1.Play;
  end
  else
  begin
    TransparentFlashPlayerControl1.FlashVars := 'FLVPath=http://FLV/FlashVideo.flv';
    TransparentFlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
    TransparentFlashPlayerControl1.Play;
  end;

  ResourceStream.Free;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  SetGlobalOnLoadExternalResourceHandler(OnGlobalLoadExternalResource);

  CheckBoxEnableStandartFlashMenu.Checked := FlashPlayerControl1.StandartMenu;
  CheckBoxEnableSounds.Checked := FlashPlayerControl.GetAudioEnabled;

  CheckBoxTransparent.Checked := TransparentFlashPlayerControl1.Visible;

  ButtonPlaySWFClick(ButtonPlaySWF);
end;

procedure TMainForm.OnGlobalLoadExternalResource(const URL: WideString; Stream: TStream);
var
  ResourceStream: TResourceStream;
begin
  if URL = 'http://FLV/FlashVideo.flv' then
  begin
    ResourceStream := TResourceStream.Create(0, 'FlashVideo', 'FLV');
    ResourceStream.SaveToStream(Stream);
    ResourceStream.Free;
  end;
end;

procedure TMainForm.ButtonPlaySWFClick(Sender: TObject);
var
  ResourceStream: TResourceStream;
begin
  FPlaySWF := True;

  ResourceStream := TResourceStream.Create(0, 'Movie', 'SWF');

  if FlashPlayerControl1.Visible then
  begin
    FlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
    FlashPlayerControl1.Play;
  end
  else
  begin
    TransparentFlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
    TransparentFlashPlayerControl1.Play;
  end;

  ResourceStream.Free;
end;

procedure TMainForm.CheckBoxEnableStandartFlashMenuClick(Sender: TObject);
begin
  FlashPlayerControl1.StandartMenu := CheckBoxEnableStandartFlashMenu.Checked;
  TransparentFlashPlayerControl1.StandartMenu := CheckBoxEnableStandartFlashMenu.Checked;
end;

procedure TMainForm.CheckBoxEnableSoundsClick(Sender: TObject);
begin
  FlashPlayerControl.SetAudioEnabled(CheckBoxEnableSounds.Checked);
end;

procedure TMainForm.CheckBoxTransparentClick(Sender: TObject);
begin
  FlashPlayerControl1.Visible := Not CheckBoxTransparent.Checked;
  TransparentFlashPlayerControl1.Visible := CheckBoxTransparent.Checked;

  if FPlaySWF then ButtonPlaySWFClick(ButtonPlaySWF) else ButtonPlayFLVClick(ButtonPlayFLV);
end;

procedure TMainForm.ButtonSiteClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonOrderClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/order.html?from_program=1', nil, nil, SW_SHOW);
end;

var
  FlashOcxFileName: string;
  FlashCodeStream: TStream;

initialization

FlashOcxFileName :=
{$IFDEF WIN64}
  'Flash64_32_0_0_371.ocx';
{$ELSE}
  'Flash32_32_0_0_371.ocx';
{$ENDIF}

  if Not IsFlashInstalled then
  begin
    FlashCodeStream := TFileStream.Create(ExpandFileName(ExtractFileDir(Application.ExeName) + '\' + FlashOcxFileName), fmOpenRead);
    try
      FlashPlayerControl.LoadFlashOCXCodeFromStream(FlashCodeStream);
    finally
      FlashCodeStream.Free;
    end;
  end;

end.
