//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MainUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "FlashPlayerControl"
#pragma resource "*.dfm"
#pragma resource "res\\movie.res"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  if (!Flashplayercontrol::IsFlashInstalled())
  {
    ShowMessage("The application needs Flash\nFlash is not installed");
    Application->Terminate();
  }

  SetGlobalOnLoadExternalResourceHandler(OnGlobalLoadExternalResource);

  CheckBoxEnableStandartFlashMenu->Checked = FlashPlayerControl1->StandartMenu;
  CheckBoxEnableSounds->Checked = Flashplayercontrol::GetAudioEnabled;

  CheckBoxTransparent->Checked = TransparentFlashPlayerControl1->Visible;

  ButtonPlaySWFClick(ButtonPlaySWF);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonOrderClick(TObject *Sender)
{
  ShellExecute(0, NULL, "http://www.f-in-box.com/delphi/order.html", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonPlayFLVClick(TObject *Sender)
{
  TFlashVersion UsingFlashVersion;
  Flashplayercontrol::GetUsingFlashVersion(UsingFlashVersion);

  // Check high version component, i.e. flash version must be at least 7.*.*.*
  if (UsingFlashVersion.version[3] < 7)
  {
    char Message[1024];
    wsprintf(Message, "The Sample needs Flash 7 or higher to play Flash Video\nCurrent version of Flash: %d.%d.%d.%d", UsingFlashVersion.version[3], UsingFlashVersion.version[2], UsingFlashVersion.version[1], UsingFlashVersion.version[0]);
    ShowMessage(Message);
    return;
  }

  FPlaySWF = false;

  TResourceStream* ResourceStream = new TResourceStream(0, "FLVPlayer", "SWF");

  if (FlashPlayerControl1->Visible)
  {
    FlashPlayerControl1->FlashVars = "FLVPath=http://FLV/FlashVideo.flv";
    FlashPlayerControl1->LoadMovieFromStream(0, ResourceStream);
    FlashPlayerControl1->Play();
  }
  else
  {
    TransparentFlashPlayerControl1->FlashVars = "FLVPath=http://FLV/FlashVideo.flv";
    TransparentFlashPlayerControl1->LoadMovieFromStream(0, ResourceStream);
    TransparentFlashPlayerControl1->Play();
  }

  delete ResourceStream;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonPlaySWFClick(TObject *Sender)
{
  FPlaySWF = true;

  TResourceStream* ResourceStream = new TResourceStream(0, "Movie", "SWF");

  if (FlashPlayerControl1->Visible)
  {
    FlashPlayerControl1->LoadMovieFromStream(0, ResourceStream);
    FlashPlayerControl1->Play();
  }
  else
  {
    TransparentFlashPlayerControl1->LoadMovieFromStream(0, ResourceStream);
    TransparentFlashPlayerControl1->Play();
  }

  delete ResourceStream;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ButtonSiteClick(TObject *Sender)
{
  ShellExecute(0, NULL, "http://www.f-in-box.com/delphi/", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CheckBoxEnableSoundsClick(TObject *Sender)
{
  Flashplayercontrol::SetAudioEnabled(CheckBoxEnableSounds->Checked);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CheckBoxEnableStandartFlashMenuClick(
      TObject *Sender)
{
  FlashPlayerControl1->StandartMenu = CheckBoxEnableStandartFlashMenu->Checked;
  TransparentFlashPlayerControl1->StandartMenu = CheckBoxEnableStandartFlashMenu->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::CheckBoxTransparentClick(TObject *Sender)
{
  FlashPlayerControl1->Visible = !CheckBoxTransparent->Checked;
  TransparentFlashPlayerControl1->Visible = CheckBoxTransparent->Checked;

  if (FPlaySWF) ButtonPlaySWFClick(ButtonPlaySWF); else ButtonPlayFLVClick(ButtonPlayFLV);
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::OnGlobalLoadExternalResource(const WideString URL, Classes::TStream* Stream)
{
  if (URL == WideString("http://FLV/FlashVideo.flv"))
  {
    TResourceStream* ResourceStream = new TResourceStream(0, "FlashVideo", "FLV");
    ResourceStream->SaveToStream(Stream);
    delete ResourceStream;
  }
}
//---------------------------------------------------------------------------

