{$R 'res\movie.res'}
{$R 'res\flash_ocx.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FlashPlayerControl, StdCtrls, ShellApi;

type
  TMainForm = class(TForm)
    FlashPlayerControl1: TFlashPlayerControl;
    ButtonPlayFromFile: TButton;
    ButtonPlayEmbeddedMovie: TButton;
    OpenDialog: TOpenDialog;
    ButtonAbout: TButton;
    ButtonOrder: TButton;
    procedure ButtonPlayFromFileClick(Sender: TObject);
    procedure ButtonPlayEmbeddedMovieClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonAboutClick(Sender: TObject);
    procedure ButtonOrderClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.ButtonPlayFromFileClick(Sender: TObject);
begin
  if OpenDialog.Execute then
     FlashPlayerControl1.Movie := OpenDialog.FileName;
end;

procedure TMainForm.ButtonPlayEmbeddedMovieClick(Sender: TObject);
var
   ResourceStream: TResourceStream;
begin
   ResourceStream := TResourceStream.Create(0, 'Movie', 'FLASH');
   FlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
   ResourceStream.Free;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  ResourceStream: TResourceStream;
begin
  ResourceStream := TResourceStream.Create(0, 'Movie', 'FLASH');
  FlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
  ResourceStream.Free;

  OpenDialog.InitialDir := ExtractFileDir(Application.ExeName);
end;

var
  FlashCodeStream: TResourceStream;

procedure TMainForm.ButtonAboutClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonOrderClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/order.html?from_program=1', nil, nil, SW_SHOW);
end;

var FlashOcxResourceName: string;

initialization

FlashOcxResourceName :=
{$IFDEF WIN64}
  'FlashOCXCode64';
{$ELSE}
  'FlashOCXCode32';
{$ENDIF}

  FlashCodeStream := TResourceStream.Create(0, FlashOcxResourceName, 'BIN');

  FlashPlayerControl.LoadFlashOCXCodeFromStream(FlashCodeStream);
  FlashCodeStream.Free;

end.
