{$R 'res\movie.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FlashPlayerControl, StdCtrls, ShellApi, ComCtrls, mmsystem;

type
  TMainForm = class(TForm)
    FlashPlayerControl1: TFlashPlayerControl;
    ButtonPlayFLV: TButton;
    OpenDialogFLV: TOpenDialog;
    ButtonPlaySWF: TButton;
    OpenDialogSWF: TOpenDialog;
    ButtonSite: TButton;
    ButtonOrder: TButton;
    Label1: TLabel;
    EditWAVPath: TEdit;
    ButtonBrowseWAVFile: TButton;
    ButtonStartRecording: TButton;
    ButtonStopRecording: TButton;
    CheckBoxAutoRecording: TCheckBox;
    SaveDialogWAV: TSaveDialog;
    procedure ButtonPlayFLVClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonPlaySWFClick(Sender: TObject);
    procedure ButtonSiteClick(Sender: TObject);
    procedure ButtonOrderClick(Sender: TObject);
    procedure ButtonBrowseWAVFileClick(Sender: TObject);
    procedure ButtonStartRecordingClick(Sender: TObject);
    procedure ButtonStopRecordingClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FFLVPath: String;
    FPlaySWF: Boolean;

    FStarted: boolean;
    FPWaveFormatEx: PWaveFormatEx;
    Fhmmio: Integer;

    Fwave: TMMCKInfo;
    Fdata: TMMCKInfo;

    FTotalSize: DWORD;

    procedure OnGlobalLoadExternalResource(const URL: WideString; Stream: TStream);

    procedure OnFlashAudioOpen(lpFormat: PWaveFormatEx);
    procedure OnFlashAudioWrite(lpWaveOutHdr: PWaveHdr; uSize: UINT);
    procedure OnFlashAudioClose;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.ButtonPlayFLVClick(Sender: TObject);
var
  UsingFlashVersion: TFlashVersion;
  ResourceStream: TResourceStream;
begin
  GetUsingFlashVersion(UsingFlashVersion);

  // Minimum version must be 7.*.*.*, so let's check high version component
  if (UsingFlashVersion.version[3] < 7) then
  begin
    ShowMessage(Format('The Sample needs Flash 7 or higher to play Flash Video' + #13 + 'Current version of Flash: %d.%d.%d.%d', [ UsingFlashVersion.version[3], UsingFlashVersion.version[2], UsingFlashVersion.version[1], UsingFlashVersion.version[0] ]));
    Exit;
  end;

  if OpenDialogFLV.Execute then
  begin

   if CheckBoxAutoRecording.Checked then
      ButtonStartRecordingClick(Self);

    FPlaySWF := False;

    FFLVPath := OpenDialogFLV.FileName;

    ResourceStream := TResourceStream.Create(0, 'FLVPlayer', 'FLASH');

    FlashPlayerControl1.FlashVars := 'FLVPath=' + FFLVPath;
    FlashPlayerControl1.PutMovieFromStream(ResourceStream);

    ResourceStream.Free;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  if Not IsFlashInstalled then
  begin
    ShowMessage('The application needs Flash'#13#10'Flash is not installed');
    Application.Terminate;
  end;

  SetGlobalOnLoadExternalResourceHandler(OnGlobalLoadExternalResource);

  OpenDialogFLV.InitialDir := ExtractFileDir(Application.ExeName);
  OpenDialogSWF.InitialDir := ExtractFileDir(Application.ExeName);
  SaveDialogWAV.InitialDir := ExtractFileDir(Application.ExeName);

  FPlaySWF := True;

  // FlashPlayerControl is NOT an object name, FlashPlayerControl is a name of the FlashPlayerControl module!
  FlashPlayerControl.SetAudioOutputOpenHandler(OnFlashAudioOpen);
  FlashPlayerControl.SetAudioOutputWriteHandler(OnFlashAudioWrite);
  FlashPlayerControl.SetAudioOutputCloseHandler(OnFlashAudioClose);

  ButtonStopRecording.Enabled := False;

  FStarted := False;

  ShowMessage('If you use demo version of the component, it saves only first 15 seconds of the audio');
end;

procedure TMainForm.OnGlobalLoadExternalResource(const URL: WideString; Stream: TStream);
var
  FileStream: TFileStream;
  MemoryStream: TMemoryStream;
begin
  if URL = 'http://FLV/FlashVideo.flv' then
  begin
    if Length(FFLVPath) > 0 then
    begin
      FileStream := TFileStream.Create(FFLVPath, fmOpenRead);
      MemoryStream := TMemoryStream.Create;
      MemoryStream.LoadFromStream(FileStream);
      MemoryStream.SaveToStream(Stream);
      FileStream.Free;
      MemoryStream.Free;
    end;
  end;
end;

procedure TMainForm.ButtonPlaySWFClick(Sender: TObject);
begin
  if OpenDialogSWF.Execute then
  begin
     if CheckBoxAutoRecording.Checked then
        ButtonStartRecordingClick(Self);

     FPlaySWF := True;

     FlashPlayerControl1.Movie := OpenDialogSWF.FileName;
     FlashPlayerControl1.Play;
  end;
end;

procedure TMainForm.ButtonSiteClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonOrderClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/order.html?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonBrowseWAVFileClick(Sender: TObject);
begin
  if SaveDialogWAV.Execute then
  begin
     EditWAVPath.Text := SaveDialogWAV.FileName;
  end;
end;

procedure TMainForm.ButtonStartRecordingClick(Sender: TObject);
begin
   if FStarted then exit;

   EditWAVPath.Enabled := False;
   ButtonStartRecording.Enabled := False;
   ButtonBrowseWAVFile.Enabled := False;
   ButtonStopRecording.Enabled := True;
   CheckBoxAutoRecording.Enabled := False;

   FStarted := True;
end;

procedure TMainForm.OnFlashAudioOpen(lpFormat: PWaveFormatEx);
var
   nSize: integer;
begin
   if nil <> FPWaveFormatEx then FreeMem(FPWaveFormatEx);

   nSize := sizeof(lpFormat^) + lpFormat.cbSize;
   GetMem(FPWaveFormatEx, nSize);
   CopyMemory(FPWaveFormatEx, lpFormat, nSize);
end;

function mmioFOURCC(ch0: char; ch1: char; ch2: char; ch3: char): integer;
begin
   Result := byte(ch0) Or (byte(ch1) shl 8) Or (byte(ch2) shl 16) Or (byte(ch3) shl 24);
end;

procedure TMainForm.OnFlashAudioWrite(lpWaveOutHdr: PWaveHdr; uSize: UINT);
var
   fmt: TMMCKInfo;
begin
   if not FStarted then exit;

   if 0 = Fhmmio then
   begin
        FTotalSize := 0;

        Fhmmio := mmioOpen(PChar(EditWAVPath.Text), nil, MMIO_ALLOCBUF Or MMIO_CREATE Or MMIO_WRITE);

        ZeroMemory(@Fwave, sizeof(Fwave));
        Fwave.fccType := mmioFOURCC('W','A','V','E');

        if MMSYSERR_NOERROR = mmioCreateChunk(Fhmmio, @Fwave, MMIO_CREATERIFF) then
        begin
             ZeroMemory(@fmt, sizeof(fmt));
             fmt.ckid := mmioFOURCC('f','m','t',' ');
             fmt.cksize := sizeof(FPWaveFormatEx^) + FPWaveFormatEx.cbSize;

             if MMSYSERR_NOERROR = mmioCreateChunk(Fhmmio, @fmt, 0) then
             begin
                  if fmt.cksize = mmioWrite(Fhmmio, PChar(FPWaveFormatEx), fmt.cksize) then
                  begin
                       if MMSYSERR_NOERROR = mmioAscend(Fhmmio, @fmt, 0) then
                       begin
                            ZeroMemory(@Fdata, sizeof(Fdata));
                            Fdata.ckid := mmioFOURCC('d','a','t','a');

                            if MMSYSERR_NOERROR = mmioCreateChunk(Fhmmio, @Fdata, 0) then
                            begin
                            end;
                       end;
                  end;
             end;
        end;
   end;

   mmioWrite(Fhmmio, lpWaveOutHdr.lpData, lpWaveOutHdr.dwBufferLength);
   FTotalSize := FTotalSize + lpWaveOutHdr.dwBufferLength;
end;

procedure TMainForm.OnFlashAudioClose;
begin
   ButtonStopRecordingClick(Self);
end;

procedure TMainForm.ButtonStopRecordingClick(Sender: TObject);
begin
   if 0 <> Fhmmio then
   begin
      mmioAscend(Fhmmio, @Fdata, 0);
      mmioAscend(Fhmmio, @Fwave, 0);
      mmioClose(Fhmmio, 0);
      Fhmmio := 0;
   end;

   EditWAVPath.Enabled := True;
   ButtonStartRecording.Enabled := True;
   ButtonBrowseWAVFile.Enabled := True;
   ButtonStopRecording.Enabled := False;
   CheckBoxAutoRecording.Enabled := True;

   FStarted := False;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  FlashPlayerControl.SetAudioOutputOpenHandler(nil);
  FlashPlayerControl.SetAudioOutputWriteHandler(nil);
  FlashPlayerControl.SetAudioOutputCloseHandler(nil);

  if nil <> FPWaveFormatEx then FreeMem(FPWaveFormatEx);
end;

end.
