{$R 'res\movie.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, FlashPlayerControl, OleCtrls, ActiveX, MSXML2_TLB,
  ComCtrls, ExtCtrls, comobj, ShellApi;

type
  TMainForm = class(TForm)
    FlashPlayerControl1: TFlashPlayerControl;
    ButtonLoad: TButton;
    PopupMenuPlay: TPopupMenu;
    LoadFLVfromafile1: TMenuItem;
    OpenDialogFLV: TOpenDialog;
    CheckBoxAutoPlay: TCheckBox;
    ButtonPause: TButton;
    ButtonPlay: TButton;
    ButtonBack: TButton;
    TrackBarVideoPos: TTrackBar;
    TimerUpdateProgress: TTimer;
    LabelCurrentPosition: TLabel;
    LabelVideoStatus: TLabel;
    ButtonForward: TButton;
    LoadFLVfromURL1: TMenuItem;
    LoadFLVfromRTMPsource1: TMenuItem;
    LoadFLVembeddedintheprogram1: TMenuItem;
    ButtonBuy: TButton;
    ButtonSite: TButton;
    ButtonSupport: TButton;
    ButtonForum: TButton;
    TrackBarSoundVolume: TTrackBar;
    Label1: TLabel;
    CheckBoxEnableSound: TCheckBox;
    procedure ButtonLoadClick(Sender: TObject);
    procedure LoadFLVfromafile1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonPauseClick(Sender: TObject);
    procedure ButtonPlayClick(Sender: TObject);
    procedure ButtonBackClick(Sender: TObject);
    procedure FlashPlayerControl1FlashCall(ASender: TObject;
      const request: WideString);
    procedure TimerUpdateProgressTimer(Sender: TObject);
    procedure TrackBarVideoPosChange(Sender: TObject);
    procedure ButtonForwardClick(Sender: TObject);
    procedure LoadFLVembeddedintheprogram1Click(Sender: TObject);
    procedure LoadFLVfromURL1Click(Sender: TObject);
    procedure ButtonBuyClick(Sender: TObject);
    procedure ButtonSiteClick(Sender: TObject);
    procedure ButtonSupportClick(Sender: TObject);
    procedure ButtonForumClick(Sender: TObject);
    procedure TrackBarSoundVolumeChange(Sender: TObject);
    procedure CheckBoxEnableSoundClick(Sender: TObject);
    procedure LoadFLVfromRTMPsource1Click(Sender: TObject);
    procedure FlashPlayerControl1LoadExternalResourceAsync(
      ASender: TObject; const Path: WideString; var Stream: TStream);
  private
    procedure OnGlobalLoadExternalResource(const URL: WideString; Stream: TStream);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses URLFormUnit;

{$R *.DFM}

procedure TMainForm.ButtonLoadClick(Sender: TObject);
var
   button: TButton;
   pt: TPoint;
begin
   button := Sender As TButton;
   pt.x := button.Left;
   pt.y := button.Top + button.Height;
   pt := ClientToScreen(pt);

   PopupMenuPlay.Popup(pt.x, pt.y);
end;

procedure TMainForm.LoadFLVfromafile1Click(Sender: TObject);
var
   rs: TResourceStream;
   FlashVars: WideString;
begin
   if OpenDialogFLV.Execute then
   begin
      rs := TResourceStream.Create(0, 'VideoPlayer', 'FLASH');

      FlashVars := 'type_video=flv&url=' + OpenDialogFLV.FileName + '&auto_play=';

      if CheckBoxAutoPlay.Checked then
         FlashVars := FlashVars + 'true'
      else
         FlashVars := FlashVars + 'false';

      FlashPlayerControl1.FlashVars := FlashVars;

      FlashPlayerControl1.PutMovieFromStream(rs);

      rs.Free;
   end
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
   rs: TResourceStream;
begin
   SetGlobalOnLoadExternalResourceHandler(OnGlobalLoadExternalResource);

   FlashPlayerControl1.AllowFullscreen := true;
   FlashPlayerControl1.BgColor := '#000000';

   rs := TResourceStream.Create(0, 'VideoPlayer', 'FLASH');
   FlashPlayerControl1.PutMovieFromStream(rs);
   rs.Free;
end;

procedure TMainForm.ButtonPauseClick(Sender: TObject);
begin
   FlashPlayerControl1.CallFunction('<invoke name="pauseVideo" returntype="void"><arguments></arguments></invoke>');
end;

procedure TMainForm.ButtonPlayClick(Sender: TObject);
begin
   FlashPlayerControl1.CallFunction('<invoke name="resumeVideo" returntype="void"><arguments></arguments></invoke>');
end;

procedure TMainForm.ButtonBackClick(Sender: TObject);
var
   doc: IXMLDOMDocument;
   XMLCurrentPosition: WideString;
   strCurrentPosition: WideString;
   CurrentPosition: Real;
   OldDecimalSeparator: Char;
begin
   doc := CoDOMDocument.Create As IXMLDOMDocument;
   try
   XMLCurrentPosition := FlashPlayerControl1.CallFunction('<invoke name="getCurrPosition" returntype="xml"><arguments></arguments></invoke>');
   doc.loadXML(XMLCurrentPosition);
   strCurrentPosition := doc.DocumentElement.text;
   OldDecimalSeparator := DecimalSeparator;
   try
      DecimalSeparator := '.';
      CurrentPosition := StrToFloat(strCurrentPosition);
      CurrentPosition := CurrentPosition - 5;
      FlashPlayerControl1.CallFunction(Format('<invoke name="seekVideo" returntype="xml"><arguments><number>%d</number></arguments></invoke>', [ Trunc(CurrentPosition) ]));
   finally
      DecimalSeparator := OldDecimalSeparator;
   end;
   except
      on E: EOleException do ;
   end
end;

procedure TMainForm.FlashPlayerControl1FlashCall(ASender: TObject;
  const request: WideString);
var
   doc: IXMLDOMDocument;
   RequestName: WideString;
   XMLDuration: WideString;
   strDuration: WideString;
   Duration: Real;
   OldDecimalSeparator: Char;
   VideoStatus: WideString;
begin
   doc := CoDOMDocument.Create As IXMLDOMDocument;
   doc.loadXML(request);

   RequestName := doc.DocumentElement.getAttribute('name');

   if RequestName = 'onMetaData' then
      // Metadata (i.e. information about video) available
   begin
        XMLDuration := FlashPlayerControl1.CallFunction('<invoke name="getDuration" returntype="xml"><arguments></arguments></invoke>');
        doc.loadXML(XMLDuration);
        strDuration := doc.DocumentElement.text;
        OldDecimalSeparator := DecimalSeparator;
        try
           DecimalSeparator := '.';
           Duration := StrToFloat(strDuration);
           TrackBarVideoPos.Max := Round(Duration);
           TimerUpdateProgress.Enabled := true;
        finally
           DecimalSeparator := OldDecimalSeparator;
        end;
   end
   else
   if RequestName = 'onVideoStatus' then
   begin
        VideoStatus := doc.DocumentElement.childNodes[0].childNodes[0].text;

        if VideoStatus = 'NetConnection.Connect.Success' then
           LabelVideoStatus.Caption := 'Connected'
        else if VideoStatus = 'NetStream.Play.Start' then
           LabelVideoStatus.Caption := 'Ready to play'
        else if VideoStatus = 'NetStream.Play.StreamNotFound' then
           LabelVideoStatus.Caption := 'Video source not found'
        else if VideoStatus = 'NetStream.Play.Stop' then
        begin
           LabelVideoStatus.Caption := 'Stopped';

           TimerUpdateProgress.Enabled := false;
        end;
   end;
end;

procedure TMainForm.TimerUpdateProgressTimer(Sender: TObject);
var
   doc: IXMLDOMDocument;
   XMLCurrentPosition: WideString;
   strCurrentPosition: WideString;
   CurrentPosition: Real;
   OldDecimalSeparator: Char;
begin
   doc := CoDOMDocument.Create As IXMLDOMDocument;
   try
   XMLCurrentPosition := FlashPlayerControl1.CallFunction('<invoke name="getCurrPosition" returntype="xml"><arguments></arguments></invoke>');
   doc.loadXML(XMLCurrentPosition);
   strCurrentPosition := doc.DocumentElement.text;
   OldDecimalSeparator := DecimalSeparator;
   try
      DecimalSeparator := '.';
      CurrentPosition := StrToFloat(strCurrentPosition);
      TrackBarVideoPos.Position := Round(CurrentPosition);

      LabelCurrentPosition.Caption := Format('%.2d:%.2d', [ Trunc(CurrentPosition), Trunc((CurrentPosition - Trunc(CurrentPosition)) * 100 ) ] );
   finally
      DecimalSeparator := OldDecimalSeparator;
   end;
   except
      on E: EOleException do ;
   end
end;

procedure TMainForm.TrackBarVideoPosChange(Sender: TObject);
begin
   if Windows.GetCapture = TrackBarVideoPos.Handle then
   begin
      FlashPlayerControl1.CallFunction(Format('<invoke name="seekVideo" returntype="xml"><arguments><number>%d</number></arguments></invoke>', [ TrackBarVideoPos.Position ]));
   end;
end;

procedure TMainForm.ButtonForwardClick(Sender: TObject);
var
   doc: IXMLDOMDocument;
   XMLCurrentPosition: WideString;
   strCurrentPosition: WideString;
   CurrentPosition: Real;
   OldDecimalSeparator: Char;
begin
   doc := CoDOMDocument.Create As IXMLDOMDocument;
   try
   XMLCurrentPosition := FlashPlayerControl1.CallFunction('<invoke name="getCurrPosition" returntype="xml"><arguments></arguments></invoke>');
   doc.loadXML(XMLCurrentPosition);
   strCurrentPosition := doc.DocumentElement.text;
   OldDecimalSeparator := DecimalSeparator;
   try
      DecimalSeparator := '.';
      CurrentPosition := StrToFloat(strCurrentPosition);
      CurrentPosition := CurrentPosition + 5;
      FlashPlayerControl1.CallFunction(Format('<invoke name="seekVideo" returntype="xml"><arguments><number>%d</number></arguments></invoke>', [ Trunc(CurrentPosition) ]));
   finally
      DecimalSeparator := OldDecimalSeparator;
   end;
   except
      on E: EOleException do ;
   end
end;

procedure TMainForm.LoadFLVembeddedintheprogram1Click(Sender: TObject);
var
   rs: TResourceStream;
   FlashVars: WideString;
begin
   FlashVars := 'type_video=flv&url=http://FLV/FlashVideo.flv&auto_play=';

   if CheckBoxAutoPlay.Checked then
      FlashVars := FlashVars + 'true'
   else
      FlashVars := FlashVars + 'false';

   FlashPlayerControl1.FlashVars := FlashVars;

   rs := TResourceStream.Create(0, 'VideoPlayer', 'FLASH');
   FlashPlayerControl1.PutMovieFromStream(rs);
   rs.Free;
end;

procedure TMainForm.OnGlobalLoadExternalResource(const URL: WideString; Stream: TStream);
var
  rs: TResourceStream;
begin
  if URL = 'http://FLV/FlashVideo.flv' then
  begin
    rs := TResourceStream.Create(0, 'FlashVideo', 'FLV');
    rs.SaveToStream(Stream);
    rs.Free;
  end;
end;

procedure TMainForm.LoadFLVfromURL1Click(Sender: TObject);
var
   form: TURLForm;
   rs: TResourceStream;
   FlashVars: WideString;
begin
   form := TURLForm.Create(Self);
   form.Caption := 'URL';

   form.Left := Left + Width div 2 - form.Width div 2;
   form.Top := Top + Height div 2 - form.Height div 2;

   if form.ShowModal = mrOK then
   begin
      FlashVars := 'type_video=flv&url=' + form.URL + '&auto_play=';

      if CheckBoxAutoPlay.Checked then
         FlashVars := FlashVars + 'true'
      else
         FlashVars := FlashVars + 'false';

      FlashPlayerControl1.FlashVars := FlashVars;

      rs := TResourceStream.Create(0, 'VideoPlayer', 'FLASH');
      FlashPlayerControl1.PutMovieFromStream(rs);
      rs.Free;
   end;

   form.Free;
end;

procedure TMainForm.ButtonBuyClick(Sender: TObject);
begin
   ShellExecute(0, nil, 'http://f-in-box.com/delphi/order.html?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonSiteClick(Sender: TObject);
begin
   ShellExecute(0, nil, 'http://f-in-box.com/delphi/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonSupportClick(Sender: TObject);
begin
   ShellExecute(0, nil, 'http://f-in-box.com/support.html?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonForumClick(Sender: TObject);
begin
   ShellExecute(0, nil, 'http://f-in-box.com/forum/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.TrackBarSoundVolumeChange(Sender: TObject);
begin
   FlashPlayerControl1.CallFunction(Format('<invoke name="setVolume" returntype="void"><arguments><number>%d</number></arguments></invoke>', [ TrackBarSoundVolume.Position * 100 div TrackBarSoundVolume.Max ]));
end;

procedure TMainForm.CheckBoxEnableSoundClick(Sender: TObject);
var
   s: string;
begin
   if (Sender As TCheckBox).Checked then s := 'false' else s := 'true';
   FlashPlayerControl1.CallFunction(Format('<invoke name="setMute" returntype="void"><arguments><%s /></arguments></invoke>', [ s ]));
end;

procedure TMainForm.LoadFLVfromRTMPsource1Click(Sender: TObject);
var
   form: TURLForm;
   rs: TResourceStream;
   FlashVars: WideString;
begin
   form := TURLForm.Create(Self);
   form.Caption := 'RTMP Source';

   form.Left := Left + Width div 2 - form.Width div 2;
   form.Top := Top + Height div 2 - form.Height div 2;

   if form.ShowModal = mrOK then
   begin
      FlashVars := 'type_video=rtmp&url=' + form.URL + '&auto_play=';

      if CheckBoxAutoPlay.Checked then
         FlashVars := FlashVars + 'true'
      else
         FlashVars := FlashVars + 'false';

      FlashPlayerControl1.FlashVars := FlashVars;

      rs := TResourceStream.Create(0, 'VideoPlayer', 'FLASH');
      FlashPlayerControl1.PutMovieFromStream(rs);
      rs.Free;
   end;

   form.Free;
end;

procedure TMainForm.FlashPlayerControl1LoadExternalResourceAsync(
  ASender: TObject; const Path: WideString; var Stream: TStream);
begin
    if Path = 'FlashVideo.flv' then
       Stream := TResourceStream.Create(0, 'FlashVideo', 'FLV');
end;

end.
