unit ProgressFormUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls;

type
  TProgressForm = class(TForm)
    ProgressBar: TProgressBar;
    ButtonStop: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ButtonStopClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    FThread: TThread;
  public
    IsClosed: boolean;
  public
    constructor Create(AOwner: TComponent; Thread: TThread);
  end;

var
  ProgressForm: TProgressForm;

implementation

{$R *.DFM}

constructor TProgressForm.Create(AOwner: TComponent; Thread: TThread);
begin
   FThread := Thread;
   IsClosed := False;

   inherited Create(AOwner);

   Visible := True;
end;

procedure TProgressForm.FormCreate(Sender: TObject);
begin
   FThread.Resume;
end;

procedure TProgressForm.ButtonStopClick(Sender: TObject);
begin
   Close;
end;

procedure TProgressForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
   FThread.Suspend;

   if MessageDlg('Would you like to stop encoding?', mtConfirmation, [mbYes, mbNo] , 0 ) = mrYes then
      CanClose := true
   else
      CanClose := false;

   IsClosed := CanClose;

   FThread.Resume;
end;

end.
