{$R 'res\movie.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FlashPlayerControl, StdCtrls, ShellApi, ExtCtrls, OleCtrls;

type
  TMainForm = class(TForm)
    FlashPlayerControl1: TFlashPlayerControl;
    ButtonSite: TButton;
    ButtonOrder: TButton;
    TransparentFlashPlayerControl1: TTransparentFlashPlayerControl;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ButtonCallActionScriptFunction1: TButton;
    ButtonCallActionScriptFunction2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ButtonSiteClick(Sender: TObject);
    procedure ButtonOrderClick(Sender: TObject);
    procedure FlashPlayerControl1FlashCall(ASender: TObject;
      const request: WideString);
    procedure TransparentFlashPlayerControl1FlashCall(ASender: TObject;
      const request: WideString);
    procedure ButtonCallActionScriptFunction1Click(Sender: TObject);
    procedure ButtonCallActionScriptFunction2Click(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  ResourceStream: TResourceStream;
  UsingFlashVersion: TFlashVersion;
begin
  if Not IsFlashInstalled then
  begin
    ShowMessage('The application needs Flash'#13#10'Flash is not installed');
    Application.Terminate;
  end;

  GetUsingFlashVersion(UsingFlashVersion);

  // Minimum version must be 8.*.*.*, so let's check high version component
  if (UsingFlashVersion.version[3] < 8) then
  begin
    ShowMessage('The application needs Flash 8 or higher');
    Application.Terminate;
  end;

  ResourceStream := TResourceStream.Create(0, 'ExternalInterface', 'FLASH');
  FlashPlayerControl1.PutMovieFromStream(ResourceStream);
  TransparentFlashPlayerControl1.PutMovieFromStream(ResourceStream);
  ResourceStream.Free;

  FlashPlayerControl1.Play;
end;

procedure TMainForm.ButtonSiteClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonOrderClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/order.html?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.FlashPlayerControl1FlashCall(ASender: TObject;
  const request: WideString);
begin
   FlashPlayerControl1.SetReturnValue('<string>Current time is: ' + TimeToStr(Time) + #13#10 + 'This info is returned by TMainForm.FlashPlayerControl1FlashCall()</string>');
end;

procedure TMainForm.TransparentFlashPlayerControl1FlashCall(
  ASender: TObject; const request: WideString);
begin
   TransparentFlashPlayerControl1.SetReturnValue('<string>Current time is: ' + TimeToStr(Time) + #13#10 + 'This info is returned by TMainForm.TransparentFlashPlayerControl1FlashCall()</string>');
end;

procedure TMainForm.ButtonCallActionScriptFunction1Click(Sender: TObject);
var
   Response: WideString;
begin
   Response := FlashPlayerControl1.CallFunction('<invoke name="CallMeFromApplication" returntype="xml"><arguments><string>Some text for TFlashPlayerControl</string></arguments></invoke>');
   ShowMessage(Format('The function returned: %s', [ Response ] ));
end;

procedure TMainForm.ButtonCallActionScriptFunction2Click(Sender: TObject);
var
   Response: WideString;
begin
   Response := TransparentFlashPlayerControl1.CallFunction('<invoke name="CallMeFromApplication" returntype="xml"><arguments><string>Some text for TTransparentFlashPlayerControl</string></arguments></invoke>');
   ShowMessage(Format('The function returned: %s', [ Response ] ));
end;

end.

