//---------------------------------------------------------------------------


#pragma hdrstop

#include "MainUnit.h"
#include "ProgressForm.h"
#include "EncodingThread.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

TEncodingThread::TEncodingThread(TStream *SourceStream, TStream *DestStream, unsigned int Size) :
   TThread(true)
{
   FreeOnTerminate = true;

   FSourceStream = SourceStream;
   FDestStream = DestStream;

   FSize = Size;
}

void __fastcall TEncodingThread::Execute()
{
   Synchronize(SetupProgressForm);

   unsigned char b;

   while (FSourceStream->Read(&b, sizeof(b)) > 0)
   {
      b ^= Mask;

      FDestStream->Write(&b, sizeof(b));

      if (ProgressForm->IsClosed)
         break;

      Synchronize(ChangeProgress);
   }

   FSourceStream->Free();
   FDestStream->Free();

   Synchronize(CloseProgressForm);
}

void __fastcall TEncodingThread::ChangeProgress()
{
   ProgressForm->ProgressBar->StepIt();
}

void __fastcall TEncodingThread::CloseProgressForm()
{
   ProgressForm->Free();
   ProgressForm = NULL;

   MainForm->Enabled = true;
}

void __fastcall TEncodingThread::SetupProgressForm()
{
   ProgressForm->ProgressBar->Min = 1;
   ProgressForm->ProgressBar->Max = FSize;
   ProgressForm->ProgressBar->Step = 1;
   ProgressForm->ProgressBar->Position = 0;
}

