{$R 'res\movie.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FlashPlayerControl, StdCtrls, ShellApi;

type
  TMainForm = class(TForm)
    FlashPlayerControl1: TFlashPlayerControl;
    ButtonPlayFromFile: TButton;
    ButtonPlayEmbeddedSWF: TButton;
    ButtonSite: TButton;
    ButtonOrder: TButton;
    ButtonSaveAsBitmap: TButton;
    SaveAsBitmapDialog: TSaveDialog;
    OpenSWFDialog: TOpenDialog;
    procedure ButtonPlayFromFileClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonSiteClick(Sender: TObject);
    procedure ButtonOrderClick(Sender: TObject);
    procedure ButtonPlayEmbeddedSWFClick(Sender: TObject);
    procedure ButtonSaveAsBitmapClick(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.ButtonPlayFromFileClick(Sender: TObject);
begin
  if OpenSWFDialog.Execute then
  begin
    FlashPlayerControl1.Movie := OpenSWFDialog.FileName;
    FlashPlayerControl1.Play;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  ResourceStream: TResourceStream;
begin
  if Not IsFlashInstalled then
  begin
    ShowMessage('The application needs Flash'#13#10'Flash is not installed');
    Application.Terminate;
  end;

  ResourceStream := TResourceStream.Create(0, 'Movie', 'SWF');
  FlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
  FlashPlayerControl1.Play;
  ResourceStream.Free;

  OpenSWFDialog.InitialDir := ExtractFileDir(Application.ExeName);
  SaveAsBitmapDialog.InitialDir := ExtractFileDir(Application.ExeName);
end;

procedure TMainForm.ButtonSiteClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonOrderClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.f-in-box.com/delphi/order.html?from_program=1', nil, nil, SW_SHOW);
end;

procedure TMainForm.ButtonPlayEmbeddedSWFClick(Sender: TObject);
var
  ResourceStream: TResourceStream;
begin
  ResourceStream := TResourceStream.Create(0, 'Movie', 'SWF');
  FlashPlayerControl1.LoadMovieFromStream(0, ResourceStream);
  FlashPlayerControl1.Play;
  ResourceStream.Free;
end;

procedure TMainForm.ButtonSaveAsBitmapClick(Sender: TObject);
var
  Bitmap: TBitmap;
  Picture: TPicture;
begin
  Picture := TPicture.Create;
  Bitmap := FlashPlayerControl1.CreateFrameBitmap;
  Picture.Bitmap := Bitmap;

  if SaveAsBitmapDialog.Execute then
  begin
    Picture.SaveToFile(SaveAsBitmapDialog.FileName);
  end;

  Bitmap.Free;
  Picture.Free;
end;

end.

