//---------------------------------------------------------------------------


#pragma hdrstop

#include "ContentProviderThread.h"
#include "MainUnit.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

TContentProviderThread::TContentProviderThread(TStream *SourceStream, TStream *DestStream, unsigned int Speed) :
   TThread(false)
{
   FSourceStream = SourceStream;
   FDestStream = DestStream;
}

void __fastcall TContentProviderThread::Execute()
{
   const int BufferSize = 1024 * 1024;
   unsigned char* pBuffer = new unsigned char[BufferSize];

   while (true)
   {
        int nReadBytes = FSourceStream->Read(pBuffer, BufferSize);

        if (0 == nReadBytes)
           break;

        if (0 == FDestStream->Write(pBuffer, nReadBytes))
           // Loading is interrupted
           break;
   }

   FSourceStream->Free();
   FDestStream->Free();

   FreeOnTerminate = true;
}

