//---------------------------------------------------------------------------

#ifndef ContentProviderThreadH
#define ContentProviderThreadH
//---------------------------------------------------------------------------

#include <Classes.hpp>

class TContentProviderThread : public TThread
{
private:
   unsigned int FSpeed, FDelay;
   unsigned int FBufferSize;
   bool FStop;
   unsigned int FLoadedBytes;
   TStream *FSourceStream, *FDestStream;

   TMemoryStream* FBuffer;

public:
   TContentProviderThread(TStream *SourceStream, TStream *DestStream, unsigned int Speed);

private:
   void __fastcall Execute();
   void __fastcall PrepareBuffer();
   void __fastcall DoWrite();
   void __fastcall UpdateGUI();
};

#endif
