{$R 'res\resources.res'}

unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, ShockwaveFlashObjects_TLB, registry,
  BoxedAppSDK_Static, StdCtrls, ShellApi;

type
  TForm1 = class(TForm)
    ShockwaveFlash1: TShockwaveFlash;
    Label1: TLabel;
    Label2: TLabel;
    ButtonSite: TButton;
    ButtonBuy: TButton;
    procedure ButtonSiteClick(Sender: TObject);
    procedure ButtonBuyClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

procedure CreateVirtualFlashOCX;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure CreateVirtualFlashOCX;
var
   ResourceStream: TResourceStream;
   HandleStream: THandleStream;
   hVirtualFile_FlashOCX: THandle;
begin
   // Create virtual file C:\Flash9e.ocx that contains flash9e.ocx
   hVirtualFile_FlashOCX := BoxedAppSDK_CreateVirtualFile('C:\Flash9e.ocx', GENERIC_ALL, FILE_SHARE_READ, nil, CREATE_NEW, 0, 0);
   HandleStream := THandleStream.Create(hVirtualFile_FlashOCX);
   ResourceStream := TResourceStream.Create(0, 'FLASH_OCX', 'BIN');
   HandleStream.CopyFrom(ResourceStream, ResourceStream.Size);
   HandleStream.Free;
   ResourceStream.Free;
   CloseHandle(hVirtualFile_FlashOCX);

   BoxedAppSDK_RegisterCOMLibraryInVirtualRegistry('C:\Flash9e.ocx');
end;

var
   hVirtualFile_Movie: THandle;
   HandleStream: THandleStream;
   ResourceStream: TResourceStream;

procedure TForm1.ButtonSiteClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.boxedapp.com/', nil, nil, SW_SHOW);
end;

procedure TForm1.ButtonBuyClick(Sender: TObject);
begin
  ShellExecute(0, nil, 'http://www.boxedapp.com/order.html', nil, nil, SW_SHOW);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   ShockwaveFlash1.Movie := 'C:\movie.swf';
end;

initialization

   BoxedAppSDK_Init;

   CreateVirtualFlashOCX;

   hVirtualFile_Movie := BoxedAppSDK_CreateVirtualFile('C:\movie.swf', GENERIC_ALL, FILE_SHARE_READ, nil, CREATE_NEW, 0, 0);
   HandleStream := THandleStream.Create(hVirtualFile_Movie);
   ResourceStream := TResourceStream.Create(0, 'SWF1', 'SWF');
   HandleStream.CopyFrom(ResourceStream, ResourceStream.Size);
   HandleStream.Free;
   ResourceStream.Free;
   CloseHandle(hVirtualFile_Movie);

end.
