using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Security.Cryptography;
using System.IO;

namespace Sample8_PlayEncryptedVideo
{
    public partial class EncryptVideoForm : Form
    {
        bool _askedToPlay = false;
        public bool AskedToPlay
        {
            get
            {
                return _askedToPlay;
            }
        }

        string _encryptedFilePath;
        public string EncryptedFilePath
        {
            get
            {
                return _encryptedFilePath;
            }
        }

        public EncryptVideoForm()
        {
            InitializeComponent();
        }

        private void buttonBrowseSourceVideo_Click(object sender, EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();

            if (dlg.ShowDialog() == DialogResult.OK)
            {
                textBoxSourceVideoPath.Text = dlg.FileName;

                if (0 == textBoxEncryptedVideoPath.Text.Length)
                    textBoxEncryptedVideoPath.Text = textBoxSourceVideoPath.Text + ".enc";
            }
        }

        private void buttonBrowseEncryptedVideo_Click(object sender, EventArgs e)
        {
            SaveFileDialog dlg = new SaveFileDialog();

            if (dlg.ShowDialog() == DialogResult.OK)
            {
                textBoxEncryptedVideoPath.Text = dlg.FileName;
            }
        }

        private void buttonEncrypt_Click(object sender, EventArgs e)
        {
            if (File.Exists(textBoxEncryptedVideoPath.Text))
            {
                if (DialogResult.No == MessageBox.Show(string.Format("The file {0} already exists.\r\nWould you like to overwrite it?", textBoxEncryptedVideoPath.Text), "Question", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2))
                    return;
            }

            using (FileStream InputVideoFile = new FileStream(textBoxSourceVideoPath.Text, FileMode.Open, FileAccess.Read, FileShare.Read))
            {
                using (FileStream EncryptedVideoFile = new FileStream(textBoxEncryptedVideoPath.Text, FileMode.Create))
                {
                    ProgressForm ProgressForm = new ProgressForm(InputVideoFile, EncryptedVideoFile);
                    
                    ProgressForm.ShowDialog();

                    if (!ProgressForm.Cancelled)
                    {
                        if (DialogResult.Yes == MessageBox.Show(string.Format("Would you like to play encrypted file {0} right now?", textBoxEncryptedVideoPath.Text), "Question", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1))
                        {
                            _askedToPlay = true;
                            _encryptedFilePath = textBoxEncryptedVideoPath.Text;
                        }

                        Close();
                    }
                    else
                    {
                        File.Delete(textBoxEncryptedVideoPath.Text);
                    }
                }
            }
        }
    }
}
