using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;
using System.Security.Cryptography;

namespace Sample8_PlayEncryptedVideo
{
    static class Program
    {
        // To generate these arrays please use KeyGen application included into this sample
        public static byte[] Key = { 0x9b, 0x67, 0x14, 0xc, 0xb8, 0x7e, 0xf0, 0x4b, 0x6e, 0xd, 0x88, 0x7a, 0xf1, 0xbb, 0x33, 0xc1, 0xc1, 0x12, 0xa3, 0x1f, 0xca, 0x2d, 0xdc, 0x54 };
        public static byte[] IV = { 0x3d, 0x12, 0xe9, 0x8c, 0xea, 0x24, 0x61, 0xf0 };

        // As it's impossible to move pointer of CryptoStream to any position we split input data into chunks
        // and crypt each chunk
        public static int ChunkSize = 1024 * 1024;

        public static byte[] Encrypt(byte[] input, int size)
        {
            byte[] output;

            TripleDESCryptoServiceProvider TDES = new TripleDESCryptoServiceProvider();

            using (MemoryStream EncryptedDataStream = new MemoryStream())
            {
                using (CryptoStream CryptoStream = new CryptoStream(EncryptedDataStream, TDES.CreateEncryptor(Program.Key, Program.IV), CryptoStreamMode.Write))
                {
                    CryptoStream.Write(input, 0, size);
                    CryptoStream.FlushFinalBlock();

                    output = new byte[EncryptedDataStream.Length];
                    EncryptedDataStream.Position = 0;
                    EncryptedDataStream.Read(output, 0, output.Length);
                }
            }

            return output;
        }

        public static byte[] Decrypt(byte[] input, int size)
        {
            byte[] output = new byte[size];

            TripleDESCryptoServiceProvider TDES = new TripleDESCryptoServiceProvider();

            using (MemoryStream EncryptedDataStream = new MemoryStream(input))
            {
                using (CryptoStream CryptoStream = new CryptoStream(EncryptedDataStream, TDES.CreateDecryptor(Program.Key, Program.IV), CryptoStreamMode.Read))
                {
                    CryptoStream.Read(output, 0, size);
                }
            }

            return output;
        }

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            BoxedAppSDK.NativeMethods.BoxedAppSDK_Init();

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new MainForm());
        }
    }
}