using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Win32;

namespace Sample5_VirtualRegistry
{
    class Program
    {
        static void Main(string[] args)
        {
            BoxedAppSDK.NativeMethods.BoxedAppSDK_Init();

            using (new BoxedAppSDK.NativeMethods.AllChangesAreVirtual())
            {
                using (RegistryKey VirtualKey = Registry.CurrentUser.CreateSubKey(@"Software\VirtualKey"))
                {
                    VirtualKey.SetValue("name1", "value1");
                    VirtualKey.SetValue("name2", 42);
                }
            }

            using (RegistryKey VirtualKey = Registry.CurrentUser.OpenSubKey(@"Software\VirtualKey"))
            {
                foreach (string ValueName in VirtualKey.GetValueNames())
                {
                    Console.WriteLine("{0}: {1}", new object[] { ValueName, VirtualKey.GetValue(ValueName) });
                }
            }

            using (RegistryKey SoftwareKey = Registry.CurrentUser.OpenSubKey(@"Software"))
            {
                foreach (string strSubKeyName in SoftwareKey.GetSubKeyNames())
                {
                    if (strSubKeyName == "VirtualKey")
                        Console.WriteLine("virtual subkey found: {0}", new object[] { strSubKeyName });
                }
            }
        }
    }
}
