{$R 'res\resources.res'}

program Sample02_HookRemoteProcess;

uses
  Forms,
  BoxedAppSDK_Static in '..\..\!Common\BoxedAppSDK_Static.pas', 
  Windows, SysUtils, Classes;

{$R *.RES}

var
   hVirtualFile: THandle;
   HandleStream: THandleStream;
   ResourceStream: TResourceStream;

   si: TSTARTUPINFO;
   pi: TPROCESSINFORMATION;

begin
  Application.Initialize;

  BoxedAppSDK_Init;

   hVirtualFile:= BoxedAppSDK_CreateVirtualFile('1.exe', GENERIC_WRITE, FILE_SHARE_READ, nil, CREATE_NEW, 0, 0);
   HandleStream := THandleStream.Create(hVirtualFile);
   ResourceStream := TResourceStream.Create(0, 'EXE1', 'EXE');
   HandleStream.CopyFrom(ResourceStream, ResourceStream.Size);
   HandleStream.Free;
   ResourceStream.Free;
   CloseHandle(hVirtualFile);

   hVirtualFile:= BoxedAppSDK_CreateVirtualFile('Dll1.dll', GENERIC_WRITE, FILE_SHARE_READ, nil, CREATE_NEW, 0, 0);
   HandleStream := THandleStream.Create(hVirtualFile);
   ResourceStream := TResourceStream.Create(0, 'DLL1', 'DLL');
   HandleStream.CopyFrom(ResourceStream, ResourceStream.Size);
   HandleStream.Free;
   ResourceStream.Free;
   CloseHandle(hVirtualFile);

   hVirtualFile:= BoxedAppSDK_CreateVirtualFile('1.txt', GENERIC_WRITE, FILE_SHARE_READ, nil, CREATE_NEW, 0, 0);
   HandleStream := THandleStream.Create(hVirtualFile);
   ResourceStream := TResourceStream.Create(0, 'TXT1', 'TXT');
   HandleStream.CopyFrom(ResourceStream, ResourceStream.Size);
   HandleStream.Free;
   ResourceStream.Free;
   CloseHandle(hVirtualFile);

   ZeroMemory(@si, sizeof(si));
   ZeroMemory(@pi, sizeof(pi));
   si.cb := sizeof(si);
   si.dwFlags := STARTF_USESHOWWINDOW;
   si.wShowWindow := SW_SHOW;

   if CreateProcess(nil, '1.exe 1.txt', nil, nil, true, CREATE_SUSPENDED, nil, nil, si, pi) then
   begin
      BoxedAppSDK_RemoteProcess_LoadLibrary(pi.dwProcessId, 'InjectMe.dll');
      ResumeThread(pi.hThread);

      WaitForSingleObject(pi.hProcess, INFINITE);

      CloseHandle(pi.hProcess);
      CloseHandle(pi.hThread);
   end;
end.
