library InjectMe;

uses
  SysUtils,
  Classes,
  Windows, 
  BoxedAppSDK_DLL in '..\Common\BoxedAppSDK_DLL.pas';

type
TCreateFileW = 
   function(lpFileName: PWideChar;
            dwDesiredAccess, dwShareMode: Integer;
            lpSecurityAttributes: PSecurityAttributes;
            dwCreationDisposition, dwFlagsAndAttributes: DWORD;
            hTemplateFile: THandle): THandle; stdcall;

const
   FileNameToBlock = '2.txt';

var
   OriginalCreateFileW: TCreateFileW;

function My_CreateFileW(
         lpFileName: PWideChar;
         dwDesiredAccess, dwShareMode: Integer;
         lpSecurityAttributes: PSecurityAttributes;
         dwCreationDisposition, dwFlagsAndAttributes: DWORD;
         hTemplateFile: THandle): THandle; stdcall;
begin
   // if lpFileName starts from FileNameToBlock
   if (lstrlenW(lpFileName) >= lstrlenW(FileNameToBlock)) and 
      (0 = lstrcmpiW(lpFileName + lstrlenW(lpFileName) - lstrlenW(FileNameToBlock), FileNameToBlock)) then
   begin
      Result := INVALID_HANDLE_VALUE;
      SetLastError(ERROR_ALREADY_EXISTS);
   end
   else
      Result := 
        OriginalCreateFileW(
           lpFileName, 
           dwDesiredAccess,
           dwShareMode, 
           lpSecurityAttributes, 
           dwCreationDisposition, 
           dwFlagsAndAttributes, 
           hTemplateFile);
end;

var
   pCreateFileW: Pointer;
   hHook__CreateFileW: THandle;

begin

  BoxedAppSDK_Init;

  pCreateFileW := GetProcAddress(GetModuleHandle('kernel32.dll'), 'CreateFileW');
  hHook__CreateFileW := BoxedAppSDK_HookFunction(pCreateFileW, @My_CreateFileW, FALSE);

  OriginalCreateFileW := BoxedAppSDK_GetOriginalFunction(hHook__CreateFileW);
  BoxedAppSDK_EnableHook(hHook__CreateFileW, TRUE);

end.
