using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Security.Cryptography;
using System.IO;
using Microsoft.Win32.SafeHandles;

namespace Sample9_PlayVideoFromMemoryStream
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        private void buttonPlay_Click(object sender, EventArgs e)
        {
            MemoryStream MemoryStream = new MemoryStream();
            byte[] data = File.ReadAllBytes("source.avi");
            MemoryStream.Write(data, 0, data.Length);

            using (SafeFileHandle fileHandle =
                new SafeFileHandle(
                    BoxedAppSDK.NativeMethods.BoxedAppSDK_CreateVirtualFileBasedOnIStream(
                        @"1.avi", // name of the pseudo file
                        BoxedAppSDK.NativeMethods.EFileAccess.GenericWrite,
                        BoxedAppSDK.NativeMethods.EFileShare.Read,
                        IntPtr.Zero,
                        BoxedAppSDK.NativeMethods.ECreationDisposition.New,
                        BoxedAppSDK.NativeMethods.EFileAttributes.Normal,
                        IntPtr.Zero,
                        new VirtualFileStream(MemoryStream)
                    ),
                    true
                )
            )
            {
                // We use "using" to close the allocated handle
                // The virtual file will still exist
            }

            axWindowsMediaPlayer1.URL = @"1.avi";
        }
    }
}