unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, BoxedAppSDK_Static, StdCtrls, Registry, ShellApi;

type
  TMainForm = class(TForm)
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

var
   dwDisposition: DWORD;
   hVirtualKey: HKEY;
   VirtualKey: TRegistry;

initialization

   BoxedAppSDK_Init;

   // Let's create a virtual registry key
   BoxedAppSDK_CreateVirtualRegKey(HKEY_CURRENT_USER, 'VirtualKey', 0, nil, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, nil, hVirtualKey, @dwDisposition);
   RegCloseKey(hVirtualKey);

   // Try to open it
   VirtualKey := TRegistry.Create;

   VirtualKey.RootKey := HKEY_CURRENT_USER;
   if VirtualKey.OpenKey('VirtualKey', false) then ShowMessage('Virtual HKEY_CURRENT_USER\VirtualKey opened well');
   VirtualKey.CloseKey;

   // Create a real key
   VirtualKey.RootKey := HKEY_CURRENT_USER;
   if VirtualKey.OpenKey('RealTestKey', true) then ShowMessage('Real HKEY_CURRENT_USER\RealTestKey opened well');
   VirtualKey.CloseKey;

   // "Delete" the key HKEY_CURRENT_USER\RealTestKey, so the application will not view it
   try
      // Enter in the mode "all changes are virtual"
      BoxedAppSDK_EnableOption(DEF_BOXEDAPPSDK_OPTION__ALL_CHANGES_ARE_VIRTUAL, TRUE);

      VirtualKey.RootKey := HKEY_CURRENT_USER;

      // Deleting is not real, because the process within the mode "all changes are virtual"
      VirtualKey.DeleteKey('RealTestKey');
   finally

      // Leave the mode "all changes are virtual"
      BoxedAppSDK_EnableOption(DEF_BOXEDAPPSDK_OPTION__ALL_CHANGES_ARE_VIRTUAL, FALSE);

      VirtualKey.CloseKey;
   end;

   // Now try to open the key; we unable to do it, because the key is deleted from process environment
   VirtualKey.RootKey := HKEY_CURRENT_USER;
   if Not VirtualKey.OpenKey('RealTestKey', false) then ShowMessage('The key HKEY_CURRENT_USER\RealTestKey deleted from virtual environment, so we can''t open it');
   VirtualKey.CloseKey;

   ExitProcess(0);

end.
