// Copyright (c) Softanics
//
// BoxedApp Packer API
//
// Ask your questions here: http://boxedapp.com/support.html

#ifndef __BXPACKERAPI_H__
#define __BXPACKERAPI_H__

#define BXPACKERAPI __stdcall

#include <pshpack4.h>

#include "BoxedApp_Interfaces.h"
#include "BxPackerApi_Interfaces.h"

#ifdef __cplusplus
extern "C"
{
#endif

// Old API

DWORD BXPACKERAPI BoxedAppPackerAPI_CompileFromXMLA(LPCSTR szConfiguration);
DWORD BXPACKERAPI BoxedAppPackerAPI_CompileFromXMLW(LPCWSTR szConfiguration);

#ifdef UNICODE
#define BoxedAppPackerAPI_CompileFromXML BoxedAppPackerAPI_CompileFromXMLW
#else
#define BoxedAppPackerAPI_CompileFromXML BoxedAppPackerAPI_CompileFromXMLA
#endif // UNICODE

DWORD BXPACKERAPI BoxedAppPackerAPI_CompileProjectFileA(LPCSTR szPath);
DWORD BXPACKERAPI BoxedAppPackerAPI_CompileProjectFileW(LPCWSTR szPath);

#ifdef UNICODE
#define BoxedAppPackerAPI_CompileProjectFile BoxedAppPackerAPI_CompileProjectFileW
#else
#define BoxedAppPackerAPI_CompileProjectFile BoxedAppPackerAPI_CompileProjectFileA
#endif // UNICODE

void BXPACKERAPI BoxedAppPackerAPI_SetContext(LPCSTR szContext);

BOOL BXPACKERAPI BoxedAppPackerAPI_UpdateIconA(LPCSTR szPath, LPCSTR szIconPath);
BOOL BXPACKERAPI BoxedAppPackerAPI_UpdateIconW(LPCWSTR szPath, LPCWSTR szIconPath);

#ifdef UNICODE
#define BoxedAppPackerAPI_UpdateIcon BoxedAppPackerAPI_UpdateIconW
#else
#define BoxedAppPackerAPI_UpdateIcon BoxedAppPackerAPI_UpdateIconA
#endif // UNICODE

HANDLE BXPACKERAPI BoxedAppPackerAPI_CreateVersionBlock();

void BXPACKERAPI BoxedAppPackerAPI_VersionBlock_SetValueA(HANDLE hBlock, LPCSTR szName, LPCSTR szValue);
void BXPACKERAPI BoxedAppPackerAPI_VersionBlock_SetValueW(HANDLE hBlock, LPCWSTR szName, LPCWSTR szValue);

#ifdef UNICODE
#define BoxedAppPackerAPI_VersionBlock_SetValue BoxedAppPackerAPI_VersionBlock_SetValueW
#else
#define BoxedAppPackerAPI_VersionBlock_SetValue BoxedAppPackerAPI_VersionBlock_SetValueA
#endif // UNICODE

BOOL BXPACKERAPI BoxedAppPackerAPI_UpdateVersionInfoA(LPCSTR szPath, HANDLE hVersionBlock);
BOOL BXPACKERAPI BoxedAppPackerAPI_UpdateVersionInfoW(LPCWSTR szPath, HANDLE hVersionBlock);

#ifdef UNICODE
#define BoxedAppPackerAPI_UpdateVersionInfo BoxedAppPackerAPI_UpdateVersionInfoW
#else
#define BoxedAppPackerAPI_UpdateVersionInfo BoxedAppPackerAPI_UpdateVersionInfoA
#endif // UNICODE

BOOL BXPACKERAPI BoxedAppPackerAPI_VersionBlock_SetVersion(HANDLE hVersionBlock, WORD v1, WORD v2, WORD v3, WORD v4);

void BXPACKERAPI BoxedAppPackerAPI_DestroyVersionBlock(HANDLE hVersionBlock);

HRESULT BXPACKERAPI BxPackerApi_CreateProject(IBxProject** ppProject);

void BXPACKERAPI BxPackerApi_SetContext(LPCSTR szContext);

BOOL BXPACKERAPI BxPackerApi_IsCOMLibrary(LPCWSTR szPath);

BOOL BXPACKERAPI BxPackerApi_GetModuleBitness(LPCWSTR szPath, BOOL* pbIs32Bit);

HRESULT BXPACKERAPI BxPackerApi_CreateSnapshotManager(IBxSnapshotManager** ppSnapshotManager);

HRESULT BXPACKERAPI BxPackerApi_CreatePredefinedDirectoriesInfoProvider(IBxPredefinedDirectoriesInfoProvider** ppProvider);

BOOL BXPACKERAPI BxPackerApi_GetFileType(LPCWSTR szPath, BxEnumFileType* pType);

HRESULT BXPACKERAPI BxPackerApi_GetProjectDbVersion(LPCWSTR szPath, int* pnVersion);

HRESULT BXPACKERAPI BxPackerApi_GetXmlProjectVersion(LPCWSTR szPath, int* pnVersion);

HRESULT BXPACKERAPI BxPackerApi_GetDotNetFileTargetPlatform(LPCWSTR szPath, BxEnumDotNetFileTargetPlatform* pPlatform);

BOOL BXPACKERAPI BxPackerApi_IsExeFile(LPCWSTR szPath, BOOL* pbIsExeFile);

HRESULT BXPACKERAPI BxPackerApi_CreateImportRegFileService(IBxImportRegFileService** ppService);

#ifdef __cplusplus
}
#endif

#include <poppack.h>

#endif // !__BXPACKERAPI_H__
