// Copyright (c) Softanics

#pragma once

/// Using this class you can create a free threaded object wrapper
template <class T>
class CFreeThreadedObjectT
{
protected:
    typedef CFreeThreadedObjectT<T> CFreeThreadedObject;

private:
    /// A free threaded marshaller provided by winapi
    CComPtr<IUnknown> m_pMarshaller;

public:
    CFreeThreadedObject()
    {
        CoCreateFreeThreadedMarshaler(reinterpret_cast<IUnknown*>((T*)this), &m_pMarshaller);
    }

    virtual ~CFreeThreadedObjectT<T>()
    {
    }

    virtual HRESULT __stdcall QueryInterface(REFIID riid, void** ppvObject)
    {
        if (IsEqualIID(riid, IID_IMarshal))
            return m_pMarshaller->QueryInterface(riid, ppvObject);
        else
            return ((T*)this)->InternalQueryInterface(riid, ppvObject);
    }
};
