using System;
using System.Collections.Generic;
using System.Text;

namespace Sample2_SimplePacker
{
    class Program
    {
        static void Main(string[] args)
        {
            string strInputEXE = args[0];
            string strOutputEXE = args[1];
            string strTempFile = System.IO.Path.GetTempFileName();

            // Create copy of input EXE
            // We will update the version and icon of the copy, then we will pack the copy
            // It's better than pack the original file and then update the version / icon
            System.IO.File.Copy(strInputEXE, strTempFile, true);

            // Update version
            //
            // Create version block
            IntPtr hVersionBlock = BoxedAppPackerAPI.NativeMethods.BoxedAppPackerAPI_CreateVersionBlock();
            // Set FileDescription
            BoxedAppPackerAPI.NativeMethods.BoxedAppPackerAPI_VersionBlock_SetValue(hVersionBlock, "FileDescription", "This is a test description");
            // Set FileVersion
            BoxedAppPackerAPI.NativeMethods.BoxedAppPackerAPI_VersionBlock_SetValue(hVersionBlock, "FileVersion", "1.1 build 105");
            // Set file's version
            BoxedAppPackerAPI.NativeMethods.BoxedAppPackerAPI_VersionBlock_SetVersion(hVersionBlock, 1, 2, 3, 4);
            // Update version of temp file (we will pack this updated file below!)
            BoxedAppPackerAPI.NativeMethods.BoxedAppPackerAPI_UpdateVersionInfo(strTempFile, hVersionBlock);
            BoxedAppPackerAPI.NativeMethods.BoxedAppPackerAPI_DestroyVersionBlock(hVersionBlock);

            // Set icon if present
            if (args.Length > 2)
                BoxedAppPackerAPI.NativeMethods.BoxedAppPackerAPI_UpdateIcon(strTempFile, args[2]);

            // OK, now let's pack the updated EXE (i.e. strTempFile)
            string strConfiguration = 
                string.Format(
                
"<project project_version=\"2\" src=\"{0}\" dest=\"{1}\" cmd_line_overridden=\"false\" cmd_args=\"\" share_virtual_environment_with_child_processes=\"true\" enable_debug_log=\"false\" enable_virtual_registry=\"true\" hide_virtual_files_from_file_dialog=\"false\">" + 
    "<files>" + 
    "</files>" + 
    "<registry>" + 
        "<keys>" + 
            "<key name=\"HKEY_CLASSES_ROOT\" virtual=\"false\" virtually_deleted=\"false\">" + 
                "<values/>" + 
                "<keys/>" + 
            "</key>" + 
            "<key name=\"HKEY_CURRENT_CONFIG\" virtual=\"false\" virtually_deleted=\"false\">" + 
                "<values/>" + 
                "<keys/>" + 
            "</key>" + 
            "<key name=\"HKEY_CURRENT_USER\" virtual=\"false\" virtually_deleted=\"false\">" + 
                "<values/>" + 
                "<keys/>" + 
            "</key>" + 
            "<key name=\"HKEY_LOCAL_MACHINE\" virtual=\"false\" virtually_deleted=\"false\">" + 
                "<values/>" + 
                "<keys/>" + 
            "</key>" + 
        "</keys>" + 
    "</registry>" + 
"</project>"

, new object[] { strTempFile, strOutputEXE });

            // Pack...
            BoxedAppPackerAPI.NativeMethods.BoxedAppPackerAPI_CompileFromXML(strConfiguration);

            // Remove temp file
            System.IO.File.Delete(strTempFile);
        }
    }
}
