using System;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace BoxedAppPackerAPI
{
    internal sealed class NativeMethods
    {
        [DllImport("bxpackerapi32.dll", CharSet = CharSet.Ansi)]
        internal static extern void BoxedAppPackerAPI_SetContext(string code);

        [DllImport("bxpackerapi32.dll", CharSet = CharSet.Auto)]
        internal static extern int BoxedAppPackerAPI_CompileProjectFile(string Path);

        [DllImport("bxpackerapi32.dll", CharSet = CharSet.Auto)]
        internal static extern int BoxedAppPackerAPI_CompileFromXML(string Configuration);

        [DllImport("bxpackerapi32.dll", CharSet = CharSet.Auto)]
        internal static extern int BoxedAppPackerAPI_UpdateIcon(string EXEPath, string IconPath);

        [DllImport("bxpackerapi32.dll")]
        internal static extern IntPtr BoxedAppPackerAPI_CreateVersionBlock();

        [DllImport("bxpackerapi32.dll")]
        internal static extern void BoxedAppPackerAPI_DestroyVersionBlock(IntPtr hBlock);

        [DllImport("bxpackerapi32.dll", CharSet = CharSet.Auto)]
        internal static extern void BoxedAppPackerAPI_VersionBlock_SetValue(IntPtr hBlock, string Name, string Value);

        [DllImport("bxpackerapi32.dll")]
        internal static extern void BoxedAppPackerAPI_VersionBlock_SetVersion(IntPtr hBlock, Int16 v1, Int16 v2, Int16 v3, Int16 v4);

        [DllImport("bxpackerapi32.dll", CharSet = CharSet.Auto)]
        internal static extern bool BoxedAppPackerAPI_UpdateVersionInfo(string Path, IntPtr hBlock);
    }
}
