// Copyright (c) Softanics

#pragma once

#define DEF_BEGIN_INTERFACE_MAP()   \
    if (NULL == ppvObject) \
        return E_POINTER; \
        \
    *ppvObject = NULL; \
        \
    if (IsEqualIID(riid, IID_IUnknown))   \
        *ppvObject = this;  \
    else

#define DEF_DECLARE_INTERFACE(name) \
    if (IsEqualIID(riid, IID_##name)) \
        *ppvObject = static_cast<name*>(this); \
    else

#define DEF_DECLARE_INTERFACE_WITH_IID(name, iid) \
    if (IsEqualIID(riid, iid)) \
        *ppvObject = static_cast<name*>(this); \
    else

#define DEF_END_INTERFACE_MAP() \
    {   \
        return E_NOINTERFACE;   \
    }   \
    \
    AddRef();   \
    \
    return S_OK;
