// Copyright (c) Softanics

#pragma once

#include "FreeThreadedObjectT.h"
#include "ObjectWithCounter.h"

/// IBxProgressEvents implementation
class CBxProgressEventsImpl :
    public IBxProgressEvents,
    public CObjectWithCounter,
    public CFreeThreadedObjectT<CBxProgressEventsImpl>
{
private:
    HANDLE m_hEventFinished;
    HRESULT m_hrResult;

private:
    CBxProgressEventsImpl();

protected:
    virtual ~CBxProgressEventsImpl();

public:
    static CComPtr<CBxProgressEventsImpl> Create();

    BOOL WaitForFinish();
    HRESULT GetResult();

    virtual HRESULT STDMETHODCALLTYPE InternalQueryInterface(REFIID riid, void** ppvObject);

    // IUnknown

    virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void** ppvObject);
    virtual ULONG STDMETHODCALLTYPE AddRef();
    virtual ULONG STDMETHODCALLTYPE Release();

    // IBxProgressEvents

    virtual HRESULT STDMETHODCALLTYPE OnProgress(int nPercent);
    virtual HRESULT STDMETHODCALLTYPE OnMessage(BxEnumLogLevel level, BSTR strText);
    virtual HRESULT STDMETHODCALLTYPE OnFinished(HRESULT hr);
};
