// Copyright (c) Softanics

#include "stdafx.h"
#include "BxProgressEventsImpl.h"

int _tmain(int argc, _TCHAR* argv[])
{
    CoInitialize(NULL);

    printf("This sample shows how to combine an executable file with a DLL and a data file. Also the sample embeds command line into output executable.\r\n");
    printf("As input file files\\TestApp.exe is used. TestApp.exe takes one argument - a path to a text file - and shows this file.\r\n");

    HRESULT hr;

    CComPtr<IBxProject> pProject;

    // Create project
    if (FAILED(hr = BxPackerApi_CreateProject(&pProject)))
    {
        printf("Error: BxPackerApi_CreateProject() failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }

    // Setup input exe path
    if (FAILED(hr = pProject->put_InputPath(CComBSTR(L"files\\TestApp.exe"))))
    {
        printf("Error: IBxProject::put_InputPath() failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }

    // Setup output exe path
    if (FAILED(hr = pProject->put_OutputPath(CComBSTR(L"TestApp_packed.exe"))))
    {
        printf("Error: IBxProject::put_OutputPath() failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }

    // Add files: Dll1.dll and text_to_embed.txt
    CComPtr<IBxFileSystem> pFileSystem;
    if (FAILED(hr = pProject->get_FileSystem(&pFileSystem)))
    {
        printf("Error: IBxProject::get_FileSystem() failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }

    CComPtr<IBxFile> pExeDir;
    if (FAILED(hr = pFileSystem->get_PredefinedDirectoryById(BxEnumPredefinedDirectory_ExeDir, &pExeDir)))
    {
        printf("Error: IBxFileSystem::get_PredefinedDirectoryById(BxEnumPredefinedDirectory_ExeDir) failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }

    CComPtr<IBxFile> pDllFile;
    if (FAILED(hr = pExeDir->AddFile(CComBSTR(L"Dll1.dll"), CComBSTR(L"files\\Dll1.dll"), VARIANT_TRUE, &pDllFile)))
    {
        printf("Error: IBxFile::AddFile() failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }

    CComPtr<IBxFile> pTextFile;
    if (FAILED(hr = pExeDir->AddFile(CComBSTR(L"input.txt"), CComBSTR(L"files\\text_to_embed.txt"), VARIANT_TRUE, &pTextFile)))
    {
        printf("Error: IBxFile::AddFile() failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }

    // Overriding command line: packed exe will read command line as "TestApp.exe input.txt"
    if (FAILED(hr = pProject->put_OverrideCommandLine(VARIANT_TRUE)))
    {
        printf("Error: IBxProject::put_OverrideCommandLine() failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }
    if (FAILED(hr = pProject->put_CommandLine(CComBSTR(L"<BoxedAppVar:OldCmdLine> \"<ExeDir>\\input.txt\""))))
    {
        printf("Error: IBxProject::put_CommandLine() failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }

    printf("Going to build...\r\n");

    // Build
    CComPtr<CBxProgressEventsImpl> pBxProgressEventsImpl = CBxProgressEventsImpl::Create();
    CComPtr<IBxProgressControl> pBuildControl;
    if (FAILED(hr = pProject->BuildAsync(pBxProgressEventsImpl, &pBuildControl)))
    {
        printf("Error: IBxProject::BuildAsync() failed, hr = 0x.%8x\r\n", hr);
        return hr;
    }

    pBxProgressEventsImpl->WaitForFinish();

    if (S_OK == pBxProgressEventsImpl->GetResult())
    {
        printf("The output file is ready: TestApp_packed.exe. You can run it: it will show embedded text file.\r\n");
    }

    return 0;
}
